/*
 *        kPPP: A pppd front end for the KDE project
 *
 * $Id$
 *            Copyright (C) 1997  Bernd Wuebben
 *                 wuebben@math.cornel.edu
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _DEBUGWIDGET_
#define _DEBUGWIDGET_

#include <tqdialog.h>
#include <tqstring.h>
#include <tqlabel.h>
#include <tqmultilineedit.h>
#include <tqpushbutton.h>


class myMultiEdit : public TQMultiLineEdit {
public:

  myMultiEdit(TQWidget *parent=0, const char *name=0);

  void newLine();
  void insertChar(unsigned char c);
};


class DebugWidget : public TQDialog {
  Q_OBJECT
  TQ_OBJECT
public:
  DebugWidget(TQWidget *parent=0, const char *name=0);

  void clear();

public slots:
  void statusLabel(const TQString &);
  void toggleVisibility();
  void addChar(unsigned char);

protected:
  virtual void hideEvent(TQHideEvent *);
  virtual void resizeEvent(TQResizeEvent *e);

private:
  void enter();
  TQFrame *fline;
  TQPushButton *dismiss;
  myMultiEdit *text_window;

  TQLabel *statuslabel;
};

#endif

