/* -*- C++ -*-
 *            kPPP: A pppd front end for the KDE project
 *
 * $Id$
 *
 *            Copyright (C) 1997 Bernd Johannes Wuebben
 *                   wuebben@math.cornell.edu
 *
 * based on EzPPP:
 * Copyright (C) 1997  Jay Painter
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _ACCOUNTS_H_
#define _ACCOUNTS_H_

#include <tqwidget.h>
#include <tqpushbutton.h>
#include <tqlistbox.h>
#include "acctselect.h"

class KDialogBase;
class TQCheckBox;
class TQLineEdit;
class TQTabDialog;
class DialWidget;
class ScriptWidget;
class IPWidget;
class DNSWidget;
class GatewayWidget;

class AccountWidget : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  AccountWidget( TQWidget *parent=0, const char *name=0 );
  ~AccountWidget() {}

private slots:
  void editaccount();
  void copyaccount();
  void newaccount();
  void deleteaccount();
  void slotListBoxSelect(int);
  void resetClicked();
  void viewLogClicked();

private:
  int doTab();

signals:
  void resetaccounts();
  void resetCosts(const TQString &);
  void resetVolume(const TQString &);

private:
  TQString prettyPrintVolume(unsigned int);

  KDialogBase *tabWindow;
  DialWidget *dial_w;
  AccountingSelector *acct;
  IPWidget *ip_w;
  DNSWidget *dns_w;
  GatewayWidget *gateway_w;
  ScriptWidget *script_w;

  TQPushButton *reset;
  TQPushButton *log;
  TQLabel *costlabel;
  TQLineEdit *costedit;
  TQLabel *vollabel;
  TQLineEdit *voledit;

  TQListBox *accountlist_l;
  TQPushButton *edit_b;
  TQPushButton *copy_b;
  TQPushButton *new_b;
  TQPushButton *delete_b;
};


class QueryReset : public TQDialog {
  Q_OBJECT
  TQ_OBJECT
public:
  QueryReset(TQWidget *parent);

  enum {COSTS=1, VOLUME=2};

private slots:
  void accepted();

private:
  TQCheckBox *costs, *volume;
};

#endif

