/*
    Kopete Yahoo Protocol
    Handles logging into to the Yahoo service

    Copyright (c) 2004 Duncan Mac-Vicar P. <duncan@kde.org>

    Copyright (c) 2005 André Duffeck <duffeck@kde.org>

    Kopete (c) 2002-2005 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef LOGINTASK_H
#define LOGINTASK_H

#include "task.h"
#include "yahootypes.h"

class TQString;
class YMSGTransfer;

namespace KIO
{
	class Job;
}

/**
@author Duncan Mac-Vicar
*/
class LoginTask : public Task
{
Q_OBJECT
  TQ_OBJECT
public:
	LoginTask(Task *parent);
	~LoginTask();

	bool take(Transfer* transfer);
	virtual void onGo();

	void reset();
	void setStateOnConnect( Yahoo::Status status );
	void setVerificationWord( const TQString &word );

	const TQString &yCookie();
	const TQString &cCookie();
	const TQString &tCookie();
	const TQString &loginCookie();
protected:
	virtual bool forMe( const Transfer* transfer ) const;
	enum State { InitialState, SentVerify, GotVerifyACK, SentAuth, GotAuthACK, SentAuthResp };
	void sendVerify();
	void sendAuth(YMSGTransfer* transfer);
	void sendAuthResp(YMSGTransfer* transfer);
	void sendAuthResp_0x0b(const TQString &sn, const TQString &seed, uint sessionID);
	void sendAuthResp_pre_0x0b(const TQString &sn, const TQString &seed);
	void handleAuthResp(YMSGTransfer *transfer);
	void parseCookies( YMSGTransfer *transfer );
	void sendAuthSixteenStage1(const TQString& sn, const TQString& seed);
	void sendAuthSixteenStage2(const TQString& token);
	void sendAuthSixteenStage3(const TQString& cryptString);
protected slots:
	void handleAuthSixteenStage1Data(KIO::Job*, const TQByteArray& data);
	void handleAuthSixteenStage1Result(KIO::Job*);
	void handleAuthSixteenStage2Data(KIO::Job*, const TQByteArray& data);
	void handleAuthSixteenStage2Result(KIO::Job*);

signals:
	void haveSessionID( uint );
	void haveCookies();
	void loginResponse( int, const TQString& );
	void buddyListReady();
private:
	State mState;
	Yahoo::Status m_stateOnConnect;
	TQString m_yCookie;
	TQString m_tCookie;
	TQString m_cCookie;
	TQString m_loginCookie;
	TQString m_verificationWord;
	TQString m_stage1Data;
	TQString m_stage2Data;
	TQString m_challengeString;
	uint m_sessionID;
};

#endif
