/*
  oscarprotocol.h  -  Oscar Protocol Plugin

  Copyright (c) 2003 by Olivier Goffart <ogoffart @ kde.org>
  Kopete    (c) 2003 by the Kopete developers  <kopete-devel@kde.org>

  *************************************************************************
  *                                                                       *
  * This program is free software; you can redistribute it and/or modify  *
  * it under the terms of the GNU General Public License as published by  *
  * the Free Software Foundation; either version 2 of the License, or     *
  * (at your option) any later version.                                   *
  *                                                                       *
  *************************************************************************
*/

#ifndef ICQPROTOCOL_H
#define ICQPROTOCOL_H

#include "kopeteprotocol.h"
#include "kopetemimetypehandler.h"
#include "kopeteonlinestatus.h"

class TQComboBox;
/*class ICQUserInfoWidget;
class ICQContact;*/

namespace ICQ { class OnlineStatusManager; }

class ICQProtocolHandler : public Kopete::MimeTypeHandler
{
public:
	ICQProtocolHandler();
	void handleURL(const TQString &mimeType, const KURL & url) const;
};


class ICQProtocol : public Kopete::Protocol
{
Q_OBJECT
  TQ_OBJECT

public:
	ICQProtocol(TQObject *parent, const char *name, const TQStringList &args);
	virtual ~ICQProtocol();

	/**
	 * Return the active instance of the protocol
	 */
	static ICQProtocol *protocol();

	virtual bool canSendOffline() const;

	virtual Kopete::Contact *deserializeContact( Kopete::MetaContact *metaContact,
	                                             const TQMap<TQString, TQString> &serializedData,
	                                             const TQMap<TQString, TQString> &addressBookData );
	AddContactPage *createAddContactWidget(TQWidget *parent, Kopete::Account *account);
	KopeteEditAccountWidget *createEditAccountWidget(Kopete::Account *account, TQWidget *parent);
	Kopete::Account *createNewAccount(const TQString &accountId);

	ICQ::OnlineStatusManager *statusManager();


	const Kopete::ContactPropertyTmpl firstName;
	const Kopete::ContactPropertyTmpl lastName;
	const Kopete::ContactPropertyTmpl awayMessage;
	const Kopete::ContactPropertyTmpl emailAddress;
	const Kopete::ContactPropertyTmpl ipAddress;
	const Kopete::ContactPropertyTmpl clientFeatures;
	const Kopete::ContactPropertyTmpl buddyIconHash;
    const Kopete::ContactPropertyTmpl contactEncoding;

	const TQMap<int, TQString> &genders() { return mGenders; }
	const TQMap<int, TQString> &countries() { return mCountries; }
	const TQMap<int, TQString> &languages() { return mLanguages; }
	const TQMap<int, TQString> &encodings() { return mEncodings; }
	const TQMap<int, TQString> &maritals() { return mMarital; }
	const TQMap<int, TQString> &interests() { return mInterests; }

	void fillComboFromTable( TQComboBox*, const TQMap<int, TQString>& );
	void setComboFromTable( TQComboBox*, const TQMap<int, TQString>&, int );
	int getCodeForCombo( TQComboBox*, const TQMap<int, TQString>& );
	/* void fillTZCombo(TQComboBox *combo);
	void setTZComboValue(TQComboBox *combo, const char &tz);
	char getTZComboValue(TQComboBox *combo); */

private:
	void initGenders();
	void initLang();
	void initCountries();
	void initEncodings();
	void initMaritals();
	void initInterests();

private:
	static ICQProtocol* protocolStatic_;
	ICQ::OnlineStatusManager* statusManager_;
	TQMap<int, TQString> mGenders;
	TQMap<int, TQString> mCountries;
	TQMap<int, TQString> mLanguages;
	TQMap<int, TQString> mEncodings;
	TQMap<int, TQString> mMarital;
	TQMap<int, TQString> mInterests;
	ICQProtocolHandler protohandler;
};
#endif
// vim: set noet ts=4 sts=4 sw=4:
