 /*
  * jabberfiletransfer.h
  *
  * Copyright (c) 2004 by Till Gerken <till@tantalo.net>
  *
  * Kopete    (c) by the Kopete developers  <kopete-devel@kde.org>
  *
  * *************************************************************************
  * *                                                                       *
  * * This program is free software; you can redistribute it and/or modify  *
  * * it under the terms of the GNU General Public License as published by  *
  * * the Free Software Foundation; either version 2 of the License, or     *
  * * (at your option) any later version.                                   *
  * *                                                                       *
  * *************************************************************************
  */

#ifndef JABBERFILETRANSFER_H
#define JABBERFILETRANSFER_H

#include <tqobject.h>
#include <filetransfer.h>

class TQString;
class JabberAccount;
namespace Kopete { class Transfer; }
namespace Kopete { class FileTransferInfo; }
class JabberBaseContact;

class JabberFileTransfer : public TQObject
{

Q_OBJECT
  TQ_OBJECT

public:
	/**
	 * Constructor for an incoming transfer
	 */
	JabberFileTransfer ( JabberAccount *account, XMPP::FileTransfer *incomingTransfer );

	/**
	 * Constructor for an outgoing transfer
	 */
	JabberFileTransfer ( JabberAccount *account, JabberBaseContact *contact, const TQString &file );

	~JabberFileTransfer ();

private slots:
	void slotIncomingTransferAccepted ( Kopete::Transfer *transfer, const TQString &fileName );
	void slotTransferRefused ( const Kopete::FileTransferInfo &transfer );
	void slotTransferResult ();
	void slotTransferError ( int errorCode );

	void slotOutgoingConnected ();
	void slotOutgoingBytesWritten ( int nrWritten );

	void slotIncomingDataReady ( const TQByteArray &data );

private:
	void initializeVariables ();

	JabberAccount *mAccount;
	XMPP::FileTransfer *mXMPPTransfer;
	Kopete::Transfer *mKopeteTransfer;
	TQFile mLocalFile;
	int mTransferId;
	TQ_LLONG mBytesTransferred;
	TQ_LLONG mBytesToTransfer;

};

#endif

// vim: set noet ts=4 sts=4 tw=4:
