/***************************************************************************
                          qextendedchecklistitem.h  -  description
                             -------------------
    begin                : Sun Jan 26 2003
    copyright            : (C) 2003 by Jan Sch�fer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *  This file is part of KSambaPlugin.                                        *
 *                                                                            *
 *  KSambaPlugin is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  KSambaPlugin is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with KSambaPlugin; if not, write to the Free Software               *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA  *
 *                                                                            *
 ******************************************************************************/
  
#ifndef _TQMULTICHECKLISTITEM_H_
#define _TQMULTICHECKLISTITEM_H_

#include <tqlistview.h>

#include <tqbitarray.h>

class QMultiCheckListItem : public TQObject, public TQListViewItem {
Q_OBJECT
  TQ_OBJECT

  public:
    QMultiCheckListItem( TQListView *parent);
    ~QMultiCheckListItem() {};
    
    virtual bool isOn(int column);
    virtual bool isDisabled(int column);
      
    
  protected:
    /* reimp */
    virtual void paintCell(TQPainter *, const TQColorGroup &, int, int, int);
    
  public slots:
    virtual void setOn(int, bool);
    virtual void toggle(int);  
    virtual void setDisabled(int, bool);
    
  signals:
    void stateChanged(int, bool);    
  private:
    TQBitArray checkStates;
    TQBitArray checkBoxColumns;
    TQBitArray disableStates;
};

#endif
