/**************************************************************************

    ktrianglebutton.cpp  - The KTriangleButton widget (button with an arrow)
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Send comments and bug fixes to larrosa@kde.org
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

    Note: This widget was based on KButton as found in the kdelibs/kdeui
    KButton was originally copyrighted by Torben Weis (weis@kde.org)
    and Matthias Ettrich (ettrich@kde.org) on 1997

***************************************************************************/
#include "ktrianglebutton.h"
#include <tqpainter.h>
#include <tqdrawutil.h>
#include <tqstyle.h>

KTriangleButton::KTriangleButton( Direction d,TQWidget *_parent, const char *name )
    : TQButton( _parent , name)
{
    dir=d;
    raised = FALSE;
    setFocusPolicy( TQ_NoFocus );
}

KTriangleButton::~KTriangleButton()
{
}

void KTriangleButton::enterEvent( TQEvent* )
{
  if ( isEnabled() )
    {
      raised = TRUE;
      repaint(FALSE);
    }
}

void KTriangleButton::leaveEvent( TQEvent * )
{
  if( raised != FALSE )
    {
      raised = FALSE;
      repaint();
    }
}


void KTriangleButton::drawButton( TQPainter *_painter )
{
  paint( _painter );
}

void KTriangleButton::drawButtonLabel( TQPainter *_painter )
{
  paint( _painter );
}

void KTriangleButton::paint( TQPainter *painter )
{
  if ( isDown() || isOn() )
    {
      if ( style().styleHint(TQStyle::SH_GUIStyle) == WindowsStyle )
	qDrawWinButton( painter, 0, 0, width(),
			height(), colorGroup(), TRUE );
      else
	qDrawShadePanel( painter, 0, 0, width(),
			 height(), colorGroup(), TRUE, 2, 0L );
    }
  else if ( raised )
    {
      if ( style().styleHint(TQStyle::SH_GUIStyle) == WindowsStyle )
	qDrawWinButton( painter, 0, 0, width(), height(),
			colorGroup(), FALSE );
      else
	qDrawShadePanel( painter, 0, 0, width(), height(),
			 colorGroup(), FALSE, 2, 0L );
    }

  if (dir==Right)
  {
      int x=width()/4;
      int y=height()/6;
      int l=height()-y*2;
      int i=0;
      int maxi=width()-2*x;
      double m=(double)(l/2)/maxi;
      while (i<=maxi)
      {
          painter->drawLine(x,y+(int)(i*m),x,y+l-(int)(i*m));
          x++;
          i++;
      };
  }
  else if (dir==Left)
  {
      int x=width()/4;
      int y=height()/6;
      int l=height()-y*2;
      int i=0;
      int maxi=width()-2*x;
      x=width()-x;
      double m=(double)(l/2)/maxi;
      while (i<=maxi)
      {
          painter->drawLine(x,y+(int)(i*m),x,y+l-(int)(i*m));
          x--;
          i++;
      };

  };

}

void KTriangleButton::mousePressEvent(TQMouseEvent *e)
{
    TQButton::mousePressEvent(e);
    usingTimer=true;
    startTimer(500);
    timeCount=0;

}

void KTriangleButton::mouseReleaseEvent(TQMouseEvent *e)
{
    usingTimer=false;
    TQButton::mouseReleaseEvent(e);
}

void KTriangleButton::timerEvent(TQTimerEvent *)
{
    if (!usingTimer) {TQT_TQOBJECT(this)->killTimers();return;};
    if (timeCount==0)
    {
        timeCount++;
        TQT_TQOBJECT(this)->killTimers();
        startTimer(120);
    } else
        if (timeCount==30)
        {
            timeCount=-1;
            TQT_TQOBJECT(this)->killTimers();
            startTimer(80);
        }
    else if (timeCount>0) timeCount++;
    emit clickedQuickly();

}
#include "ktrianglebutton.moc"
