/***************************************************************************
    copyright            : (C) 2004 Nathan Toone
    email                : nathan@toonetown.com
    copyright            : (C) 2007 Michael Pyne
    email                : michael.pyne@kdemail.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEBIMAGEFETCHERDIALOG_H
#define WEBIMAGEFETCHERDIALOG_H

#include <kiconview.h>
#include <kio/job.h>

#include "webimagefetcher.h"

class KURL;

class WebImageFetcherDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    WebImageFetcherDialog(const WebImageList &urlList,
                        const FileHandle &file,
                        TQWidget *parent = 0);

    virtual ~WebImageFetcherDialog();

    TQPixmap result() const { return m_pixmap; }

    void setLayout();
    void setImageList(const WebImageList &urlList);
    void setFile(const FileHandle &file);

signals:
    void coverSelected();
    void newSearchRequested();

public slots:
    int exec();
    void refreshScreen(WebImageList &list);

protected slots:
    void slotOk();
    void slotCancel();
    void slotUser1();
    void showCreditURL(const TQString &url);

private:
    TQPixmap fetchedImage(uint index) const;
    TQPixmap pixmapFromURL(const KURL &url) const;

    TQPixmap m_pixmap;
    WebImageList m_imageList;
    KIconView *m_iconWidget;
    FileHandle m_file;
};

namespace KIO
{
    class TransferJob;
}

class CoverIconViewItem : public TQObject, public KIconViewItem
{
    Q_OBJECT
  TQ_OBJECT

public:
    CoverIconViewItem(TQIconView *parent, const WebImage &image);
    ~CoverIconViewItem();

private slots:
    void imageData(KIO::Job *job, const TQByteArray &data);
    void imageResult(KIO::Job* job);

private:
    TQByteArray m_buffer;
    TQGuardedPtr<KIO::TransferJob> m_job;
};

#endif
