/***************************************************************************
    begin                : Thu Jul 31 00:31:51 2003
    copyright            : (C) 2003 - 2004 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcombobox.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <klocale.h>

#include <tqradiobutton.h>
#include <tqvgroupbox.h>
#include <tqlabel.h>
#include <tqhbox.h>
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqhbuttongroup.h>

#include "collectionlist.h"
#include "advancedsearchdialog.h"
#include "searchwidget.h"

////////////////////////////////////////////////////////////////////////////////
// public methods
////////////////////////////////////////////////////////////////////////////////

AdvancedSearchDialog::AdvancedSearchDialog(const TQString &defaultName,
					   const PlaylistSearch &defaultSearch,
                                           TQWidget *parent,
                                           const char *name) :
    KDialogBase(parent, name, true, i18n("Create Search Playlist"), Ok|Cancel)
{
    makeVBoxMainWidget();

    TQHBox *box = new TQHBox(mainWidget());
    box->setSpacing(5);

    new TQLabel(i18n("Playlist name:"), box);
    m_playlistNameLineEdit = new KLineEdit(defaultName, box);

    TQVGroupBox *criteriaGroupBox = new TQVGroupBox(i18n("Search Criteria"), mainWidget());
    static_cast<TQHBox *>(mainWidget())->setStretchFactor(criteriaGroupBox, 1);

    TQHButtonGroup *group = new TQHButtonGroup(criteriaGroupBox);
    m_matchAnyButton = new TQRadioButton(i18n("Match any of the following"), group);
    m_matchAllButton = new TQRadioButton(i18n("Match all of the following"), group);

    m_criteria = new TQVBox(criteriaGroupBox);

    if(defaultSearch.isNull()) {
        m_searchLines.append(new SearchLine(m_criteria));
        m_searchLines.append(new SearchLine(m_criteria));
        m_matchAnyButton->setChecked(true);
    }
    else {
        PlaylistSearch::ComponentList components = defaultSearch.components();
        for(PlaylistSearch::ComponentList::ConstIterator it = components.begin();
            it != components.end();
            ++it)
        {
            SearchLine *s = new SearchLine(m_criteria);
            s->setSearchComponent(*it);
            m_searchLines.append(s);
        }
        if(defaultSearch.searchMode() == PlaylistSearch::MatchAny)
            m_matchAnyButton->setChecked(true);
        else
            m_matchAllButton->setChecked(true);
    }

    TQWidget *buttons = new TQWidget(criteriaGroupBox);
    TQBoxLayout *l = new TQHBoxLayout(buttons, 0, 5);

    KPushButton *clearButton = new KPushButton(KStdGuiItem::clear(), buttons);
    connect(clearButton, TQT_SIGNAL(clicked()), TQT_SLOT(clear()));
    l->addWidget(clearButton);

    l->addStretch(1);

    m_moreButton = new KPushButton(i18n("More"), buttons);
    connect(m_moreButton, TQT_SIGNAL(clicked()), TQT_SLOT(more()));
    l->addWidget(m_moreButton);

    m_fewerButton = new KPushButton(i18n("Fewer"), buttons);
    connect(m_fewerButton, TQT_SIGNAL(clicked()), TQT_SLOT(fewer()));
    l->addWidget(m_fewerButton);

    m_playlistNameLineEdit->setFocus();
}

AdvancedSearchDialog::~AdvancedSearchDialog()
{

}

////////////////////////////////////////////////////////////////////////////////
// public slots
////////////////////////////////////////////////////////////////////////////////

AdvancedSearchDialog::Result AdvancedSearchDialog::exec()
{
    Result r;
    r.result = DialogCode(KDialogBase::exec());
    r.search = m_search;
    r.playlistName = m_playlistName;
    return r;
}

////////////////////////////////////////////////////////////////////////////////
// protected slots
////////////////////////////////////////////////////////////////////////////////

void AdvancedSearchDialog::accept()
{
    m_search.clearPlaylists();
    m_search.clearComponents();

    m_search.addPlaylist(CollectionList::instance());

    TQValueListConstIterator<SearchLine *> it = m_searchLines.begin();
    for(; it != m_searchLines.end(); ++it)
        m_search.addComponent((*it)->searchComponent());

    PlaylistSearch::SearchMode m = PlaylistSearch::SearchMode(!m_matchAnyButton->isChecked());
    m_search.setSearchMode(m);

    m_playlistName = m_playlistNameLineEdit->text();

    KDialogBase::accept();
}

void AdvancedSearchDialog::clear()
{
    TQValueListConstIterator<SearchLine *> it = m_searchLines.begin();
    for(; it != m_searchLines.end(); ++it)
        (*it)->clear();
}

void AdvancedSearchDialog::more()
{
    SearchLine *searchLine = new SearchLine(m_criteria);
    m_searchLines.append(searchLine);
    searchLine->show();
    updateButtons();
}

void AdvancedSearchDialog::fewer()
{
    SearchLine *searchLine = m_searchLines.last();
    m_searchLines.remove(searchLine);
    delete searchLine;
    updateButtons();
}

////////////////////////////////////////////////////////////////////////////////
// private methods
////////////////////////////////////////////////////////////////////////////////

void AdvancedSearchDialog::updateButtons()
{
    m_moreButton->setEnabled(m_searchLines.count() < 16);
    m_fewerButton->setEnabled(m_searchLines.count() > 1);
}

#include "advancedsearchdialog.moc"
