#ifndef KEYS_H
#define KEYS_H

#include <tqmap.h>
#include <kaction.h>

#include "mp_interface.h"


class KeyData : public TQObject
{
 Q_OBJECT
  TQ_OBJECT
 public:
    KeyData(uint maxNb, uint nbActions, const ActionData *,
            TQObject *parent);
    void setKeycodes(uint nb, uint i, const int *keycodes);

    void setCurrentNb(uint nb);
    void clear();
    void createActionCollection(uint index, TQWidget *receiver);
    void setEnabled(uint index, bool enabled);
    void addKeys(KKeyDialog &);
    void save();

    void keyEvent(TQKeyEvent *e, bool pressed);

 private:
    uint                                   _maxNb;
    TQMemArray<ActionData>                  _data;
    TQMap<int, TQMap<int, TQMemArray<int> > > _keycodes;
    TQMemArray<KActionCollection *>         _cols;
    struct SpecialData {
        bool enabled;
        TQSignal *pressed, *released;
    };
    TQMap<KAction *, SpecialData>           _specActions;

    TQString group() const
        { return TQString("Keys (%1 humans)").arg(_cols.size()); }
};

#endif // KEYS_H
