/*
    This file is part of the KDE games library
    Copyright (C) 2002 Nicolas Hadacek (hadacek@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KEXTHIGHSCORE_TAB_H
#define KEXTHIGHSCORE_TAB_H

#include <tqcombobox.h>
#include <tqmemarray.h>

class TQLabel;
class KListView;


namespace KExtHighscore
{

//-----------------------------------------------------------------------------
class PlayersCombo : public TQComboBox
{
 Q_OBJECT
  TQ_OBJECT
 public:
    PlayersCombo(TQWidget *parent = 0, const char *name = 0);

    void load();

 signals:
    void playerSelected(uint i);
    void allSelected();
    void noneSelected();

 private slots:
    void activatedSlot(int i);
};

//-----------------------------------------------------------------------------
class AdditionalTab : public TQWidget
{
 Q_OBJECT
  TQ_OBJECT
 public:
    AdditionalTab(TQWidget *parent, const char *name);

    virtual void load();

 private slots:
    void playerSelected(uint i) { display(i) ; }
    void allSelected();

 protected:
    void init();
    static TQString percent(uint n, uint total, bool withBraces = false);
    virtual void display(uint i) = 0;

 private:
    PlayersCombo *_combo;
};

//-----------------------------------------------------------------------------
class StatisticsTab : public AdditionalTab
{
 Q_OBJECT
  TQ_OBJECT
 public:
    StatisticsTab(TQWidget *parent);

    void load();

 private:
    enum Count { Total = 0, Won, Lost, Draw, Nb_Counts };
    static const char *COUNT_LABELS[Nb_Counts];
    enum Trend { CurrentTrend = 0, WonTrend, LostTrend, Nb_Trends };
    static const char *TREND_LABELS[Nb_Trends];
    struct Data {
        uint count[Nb_Counts];
        double trend[Nb_Trends];
    };
    TQMemArray<Data> _data;
    TQLabel *_nbs[Nb_Counts], *_percents[Nb_Counts], *_trends[Nb_Trends];

    TQString percent(const Data &, Count) const;
    void display(uint i);
};

//-----------------------------------------------------------------------------
class HistogramTab : public AdditionalTab
{
 Q_OBJECT
  TQ_OBJECT
 public:
    HistogramTab(TQWidget *parent);

    void load();

 private:
    TQMemArray<uint> _counts;
    TQMemArray<uint> _data;
    KListView       *_list;

    void display(uint i);
};

} // namespace

#endif
