/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#ifndef __PokerWindow__
#define __PokerWindow__


#include <kmainwindow.h>


class TQLabel;
class KToggleAction;
class kpok;


class PokerWindow : public KMainWindow
{
  Q_OBJECT
  TQ_OBJECT

  public:
    PokerWindow();
    ~PokerWindow();

  protected:
    virtual bool queryClose();
    bool  eventFilter(TQObject*, TQEvent*);
    void  initKAction();
    void  readOptions();

  protected slots:
    //     void saveProperties(KConfig*);
    //     void readProperties(KConfig*);
    void  setHand(const TQString &newHand, bool lastHand = true);
    void  showClickToHold(bool show);
    void  statusBarMessage(TQString);
    void  clearStatusBar();
    void  saveOptions();
    void  toggleMenubar();
    void  toggleStatusbar();

  private:
    kpok           *m_kpok;

    KToggleAction  *soundAction;
    KToggleAction  *blinkingAction;
    KToggleAction  *adjustAction;
    KToggleAction  *showMenubarAction;
    KToggleAction  *showStatusbarAction;

    // statusbar elements:
    TQLabel         *LHLabel;

    bool            clickToHoldIsShown;
};

#endif
