#ifndef SLOPE_H
#define SLOPE_H

#include <kimageeffect.h>

#include "game.h"

class Slope;
class SlopeConfig : public Config
{
	Q_OBJECT
  TQ_OBJECT

public:
	SlopeConfig(Slope *slope, TQWidget *parent);

private slots:
	void setGradient(const TQString &text);
	void setReversed(bool);
	void setStuckOnGround(bool);
	void gradeChanged(double);

private:
	Slope *slope;
};

class Slope : public TQCanvasRectangle, public CanvasItem, public RectItem
{
public:
	Slope(TQRect rect, TQCanvas *canvas);
	virtual void aboutToDie();
	virtual int rtti() const { return 1031; }

	virtual void showInfo();
	virtual void hideInfo();
	virtual void editModeChanged(bool changed);
	virtual bool canBeMovedByOthers() const { return !stuckOnGround; }
	virtual TQPtrList<TQCanvasItem> moveableItems() const;
	virtual Config *config(TQWidget *parent) { return new SlopeConfig(this, parent); }
	void setSize(int, int);
	virtual void newSize(int width, int height);

	virtual void moveBy(double dx, double dy);

	virtual void draw(TQPainter &painter);
	virtual TQPointArray areaPoints() const;

	void setGradient(TQString text);
	KImageEffect::GradientType curType() const { return type; }
	void setGrade(double grade);

	double curGrade() const { return grade; }
	void setColor(TQColor color) { this->color = color; updatePixmap(); }
	void setReversed(bool reversed) { this->reversed = reversed; updatePixmap(); }
	bool isReversed() const { return reversed; }

	bool isStuckOnGround() const { return stuckOnGround; }
	void setStuckOnGround(bool yes) { stuckOnGround = yes; updateZ(); }

	virtual void load(KConfig *cfg);
	virtual void save(KConfig *cfg);

	virtual bool collision(Ball *ball, long int id);
	virtual bool terrainCollisions() const;

	TQMap<KImageEffect::GradientType, TQString> gradientI18nKeys;
	TQMap<KImageEffect::GradientType, TQString> gradientKeys;

	virtual void updateZ(TQCanvasRectangle *vStrut = 0);

	void moveArrow();

private:
	KImageEffect::GradientType type;
	inline void setType(KImageEffect::GradientType type);
	bool showingInfo;
	double grade;
	bool reversed;
	TQColor color;
	TQPixmap pixmap;
	void updatePixmap();
	bool stuckOnGround;
	TQPixmap grass;

	void clearArrows();

	TQPtrList<Arrow> arrows;
	TQCanvasText *text;
	RectPoint *point;
};

class SlopeObj : public Object
{
public:
	SlopeObj() { m_name = i18n("Slope"); m__name = "slope"; }
	virtual TQCanvasItem *newObject(TQCanvas *canvas) { return new Slope(TQRect(0, 0, 40, 40), canvas); }
};

#endif
