//
// C++ Implementation: kvtnewstuff
//
// Description:
//
//
// Author: Peter Hedlund <peter.hedlund@kdemail.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <tqdir.h>

#include <kprocess.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>
#include <knewstuff/entry.h>

#include "kvoctrain.h"
#include "kvtnewstuff.h"
#include "prefs.h"

KVTNewStuff::KVTNewStuff(TQWidget *parent, const char * /*name*/) : TQObject(), KNewStuff("kdeedu/vocabulary", parent)
{
  m_app = (kvoctrainApp*) parent;
}


bool KVTNewStuff::install(const TQString & fileName)
{
  if (m_app->queryExit())
    m_app->loadfileFromPath(fileName, true);
  return true;
}


bool KVTNewStuff::createUploadFile(const TQString & /*fileName*/)
{
  return true;
}


TQString KVTNewStuff::destinationPath(KNS::Entry * entry)
{
  if (entry)
  {
    KURL url = entry->payload();
    TQString fileName = url.fileName();

    TQString path = Prefs::installPath(); //default is Vocabularies which will be created in the user's home directory
    TQString file;

    if (path.isEmpty())
      file = KNewStuff::downloadDestination(entry); //fall back on a temp file, should never happen
    else
    {
      file = TQDir::home().path() + "/" + path + "/";
      KStandardDirs::makeDir(file); //ensure the directory exists
      file += fileName;
    }
    return file;
  }
  else
    return TQString();
}


TQString KVTNewStuff::downloadDestination(KNS::Entry * entry)
{
  TQString file = destinationPath(entry);

  if (KStandardDirs::exists(file))
  {
    int result = KMessageBox::warningContinueCancel(parentWidget(),
        i18n("The file '%1' already exists. Do you want to overwrite it?")
        .arg(file),
        TQString(), i18n("Overwrite") );
    if (result == KMessageBox::Cancel)
      return TQString();
  }
  KMessageBox::information(parentWidget(),
    i18n("<qt>The selected file will now be downloaded and saved as\n<b>'%1'</b>.</qt>")
    .arg(file),
    TQString(),
    "NewStuffDownloadLocation");
  return file;
}


#include "kvtnewstuff.moc"
