/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;
import java.util.ArrayList;


class ImageIconProvider  extends QFileIconProvider
{
    ArrayList fmts;
    QPixmap imagepm;



/* XPM */
static String image_xpm[] = {
"17 15 9 1",
"	c #7F7F7F",
".	c #FFFFFF",
"X	c #00B6FF",
"o	c #BFBFBF",
"O	c #FF6C00",
"+	c #000000",
"@	c #0000FF",
"#	c #6CFF00",
"$	c #FFB691",
"             ..XX",
" ........o   .XXX",
" .OOOOOOOo.  XXX+",
" .O@@@@@@+++XXX++",
" .O@@@@@@O.XXX+++",
" .O@@@@@@OXXX+++.",
" .O######XXX++...",
" .O#####XXX++....",
" .O##$#$XX+o+....",
" .O#$$$$$+.o+....",
" .O##$$##O.o+....",
" .OOOOOOOO.o+....",
" ..........o+....",
" ooooooooooo+....",
"+++++++++++++...."
};

ImageIconProvider( )
{
	this(null, null);
}

ImageIconProvider( QWidget parent, String name )
{
    super( parent, name );
    imagepm = new QPixmap(image_xpm);
    fmts = QImage.inputFormats();
}


public QPixmap  pixmap( QFileInfo fi )
{
    String ext = fi.extension().toUpperCase();
    if ( fmts.indexOf(ext) != -1 ) {
	return imagepm;
    } else {
	return super.pixmap(fi);
    }
}
}
