/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;


class MDIWindow extends QMainWindow
{

private    QMultiLineEdit medit;
private    QMovie  mmovie;
private    String filename = "";

MDIWindow( QWidget parent, String name, int wflags )
{
    super( parent, name, wflags );
    mmovie = null;
    medit = new QMultiLineEdit( this );
    setFocusProxy( medit );
    setCentralWidget( medit );
}


void load( String fn )
{
    filename  = fn;
    QFile f = new QFile( filename );
    if ( !f.open( QIODevice.IO_ReadOnly ) )
	return;

    if(fn.indexOf(".gif") != -1) {
	QWidget  tmp=new QWidget(this);
	setFocusProxy(tmp);
	setCentralWidget(tmp);
	medit.hide();
	QMovie  qm=new QMovie(fn);
//	qm.setDisplayWidget(tmp);
	tmp.setBackgroundMode(QWidget.NoBackground);
	tmp.show();
	mmovie=qm;
    } else {
	mmovie = null;

	QTextStream t = new QTextStream(f);
	String s = t.read();
	medit.setText( s );
	f.close();


    }
    setCaption( filename );
    emit("message", "Loaded document " + filename, 2000 );
}

void save()
{
    if ( filename.equals("") ) {
        saveAs();
        return;
    }

    String text = medit.text();
    QFile f = new QFile( filename );
    if ( !f.open( QIODevice.IO_WriteOnly ) ) {
        emit("message", "Could not write to " + filename,
		      2000 );
        return;
    }

    QTextStream t = new QTextStream( f );
	t.writeRawBytes( text, text.length() );
    f.close();

    setCaption( filename );

    emit("message", "File " + filename + " saved", 2000 );
}

void saveAs()
{
    String fn = QFileDialog.getSaveFileName( filename, "", this );
    if ( !fn.equals("") ) {
        filename = fn;
        save();
    } else {
        emit("message", "Saving aborted", 2000 );
    }
}

void print( QPrinter printer)
{
    int Margin = 10;
    int pageNo = 1;

    if ( printer.setup(this) ) {		// printer dialog
	emit("message", "Printing...", 0 );
	QPainter p = new QPainter();
	if ( !p.begin( printer ) )
	    return;				// paint on printer
	p.setFont( medit.font() );
	int yPos        = 0;			// y position for each line
	QFontMetrics fm = p.fontMetrics();
	QPaintDeviceMetrics metrics = new QPaintDeviceMetrics( printer ); // need width/height
	// of printer surface
	for( int i = 0 ; i < medit.numLines() ; i++ ) {
	    if ( Margin + yPos > metrics.height() - Margin ) {
		String msg = "Printing (page ";
		msg += (++pageNo);
		msg += ")...";
		emit("message", msg, 0 );
		printer.newPage();		// no more room on this page
		yPos = 0;			// back to top of page
	    }
	    p.drawText( Margin, Margin + yPos,
			metrics.width(), fm.lineSpacing(),
			ExpandTabs | DontClip,
			medit.textLine( i ) );
	    yPos = yPos + fm.lineSpacing();
	}
	p.end();				// send job to printer
	emit("message", "Printing completed", 2000 );
    } else {
	emit("message", "Printing aborted", 2000 );
    }
}

}

