/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;
import java.util.ArrayList;

class ApplicationWindow extends QMainWindow
{

private    QPrinter printer;
private    QWorkspace ws;
/* Keep a copy of ws.windowList(), so that the MDIWindow
   widgets in it won't get garbage collected */
private    ArrayList windows;
private    QToolBar fileTools;
private    QPopupMenu windowsMenu;



private String  fileOpenText = "Click this button to open a <em>new file</em>. <br><br>"
+ "You can also select the <b>Open command</b> from the File menu.";
private String  fileSaveText = "Click this button to save the file you are "
+ "editing.  You will be prompted for a file name.\n\n"
+ "You can also select the Save command from the File menu.\n\n"
+ "Note that implementing this function is left as an exercise for the reader.";
private String  filePrintText = "Click this button to print the file you "
+ "are editing.\n\n"
+ "You can also select the Print command from the File menu.";

/* XPM */
static String filesave[] = {
"    14    14        4            1",
". c #040404",
"# c #808304",
"a c #bfc2bf",
"b c None",
"..............",
".#.aaaaaaaa.a.",
".#.aaaaaaaa...",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".##........##.",
".############.",
".##.........#.",
".##......aa.#.",
".##......aa.#.",
".##......aa.#.",
"b............."
};

/* XPM */
static String fileopen[] = {
"    16    13        5            1",
". c #040404",
"# c #808304",
"a c None",
"b c #f3f704",
"c c #f3f7f3",
"aaaaaaaaa...aaaa",
"aaaaaaaa.aaa.a.a",
"aaaaaaaaaaaaa..a",
"a...aaaaaaaa...a",
".bcb.......aaaaa",
".cbcbcbcbc.aaaaa",
".bcbcbcbcb.aaaaa",
".cbcb...........",
".bcb.#########.a",
".cb.#########.aa",
".b.#########.aaa",
"..#########.aaaa",
"...........aaaaa"
};

/* XPM */
static String fileprint[] = {
"    16    14        6            1",
". c #000000",
"# c #848284",
"a c #c6c3c6",
"b c #ffff00",
"c c #ffffff",
"d c None",
"ddddd.........dd",
"dddd.cccccccc.dd",
"dddd.c.....c.ddd",
"ddd.cccccccc.ddd",
"ddd.c.....c....d",
"dd.cccccccc.a.a.",
"d..........a.a..",
".aaaaaaaaaa.a.a.",
".............aa.",
".aaaaaa###aa.a.d",
".aaaaaabbbaa...d",
".............a.d",
"d.aaaaaaaaa.a.dd",
"dd...........ddd"
};

ApplicationWindow()
{
    super( null, "example application main window", WDestructiveClose );
    int id;

    QPixmap openIcon, saveIcon;

    fileTools = new QToolBar( this, "file operations" );
    addToolBar( fileTools, tr( "File Operations" ), DockTop, true );

    openIcon = new QPixmap( fileopen );
    QToolButton  fileOpen
	= new QToolButton( new QIconSet(openIcon), "Open File", "",
			   this, SLOT("load()"), fileTools, "open file" );

    saveIcon = new QPixmap( filesave );
    QToolButton  fileSave
	= new QToolButton( new QIconSet(saveIcon), "Save File", "",
			   this, SLOT("save()"), fileTools, "save file" );

    printer = new QPrinter();
    QPixmap printIcon;

    printIcon = new QPixmap( fileprint );
    QToolButton  filePrint
	= new QToolButton( new QIconSet(printIcon), "Print File", "",
			   this, SLOT("print()"), fileTools, "print file" );
    QWhatsThis.add( filePrint, filePrintText );

    QWhatsThis.whatsThisButton( fileTools );

    QWhatsThis.add( fileOpen, fileOpenText );
    QWhatsThis.add( fileSave, fileSaveText );

    QPopupMenu  file = new QPopupMenu( this );
    menuBar().insertItem( "&File", file );

    file.insertItem( "&New", this, SLOT("newDoc()"), new QKeySequence(CTRL+Key_N) );

    id = file.insertItem( new QIconSet(openIcon), "&Open...",
			   this, SLOT("load()"), new QKeySequence(CTRL+Key_O) );
    file.setWhatsThis( id, fileOpenText );

    id = file.insertItem( new QIconSet(saveIcon), "&Save",
			   this, SLOT("save()"), new QKeySequence(CTRL+Key_S) );
    file.setWhatsThis( id, fileSaveText );
    id = file.insertItem( "Save &As...", this, SLOT("saveAs()") );
    file.setWhatsThis( id, fileSaveText );
    file.insertSeparator();
    id = file.insertItem( new QIconSet(printIcon), "&Print...",
			   this, SLOT("print()"), new QKeySequence(CTRL+Key_P) );
    file.setWhatsThis( id, filePrintText );
    file.insertSeparator();
    file.insertItem( "&Close", this, SLOT("closeWindow()"), new QKeySequence(CTRL+Key_W) );
    file.insertItem( "&Quit", qApp(), SLOT(" closeAllWindows()"), new QKeySequence(CTRL+Key_Q) );

    windowsMenu = new QPopupMenu( this );
    windowsMenu.setCheckable( true );
    connect( windowsMenu, SIGNAL(" aboutToShow()"),
	     this, SLOT(" windowsMenuAboutToShow()") );
    menuBar().insertItem( "&Windows", windowsMenu );

    menuBar().insertSeparator();
    QPopupMenu  help = new QPopupMenu( this );
    menuBar().insertItem( "&Help", help );

    help.insertItem( "&About", this, SLOT("about()"), new QKeySequence(Key_F1));
    help.insertItem( "About &Qt", this, SLOT("aboutQt()"));
    help.insertSeparator();
    help.insertItem( "What's &This", this, SLOT("whatsThis()"), new QKeySequence(SHIFT+Key_F1));

    QVBox vb = new QVBox( this );
    vb.setFrameStyle( QFrame.StyledPanel | QFrame.Sunken );
    ws = new QWorkspace( vb );
    ws.setScrollBarsEnabled( true );
    setCentralWidget( vb );

    statusBar().message( "Ready", 2000 );
}


MDIWindow newDoc()
{
    MDIWindow w = new MDIWindow( ws, null, WDestructiveClose );
    connect( w, SIGNAL("message(String,int)"), statusBar(), SLOT("message(String,int)") );
    w.setCaption("unnamed document");
    w.setIcon( new QPixmap("document.xpm") );
    // show the very first window in maximized mode
	windows = ws.windowList();
    if ( windows.size() == 0 )
	w.showMaximized();
    else
	w.show();
    return w;
}

void load()
{
    String fn = QFileDialog.getOpenFileName( "", "", this );
    if ( !fn.equals("") ) {
	MDIWindow w = newDoc();
	w.load( fn );
    }  else {
	statusBar().message( "Loading aborted", 2000 );
    }
}

void save()
{
    MDIWindow m = (MDIWindow)ws.activeWindow();
    if ( m != null )
	m.save();
}


void saveAs()
{
    MDIWindow m = (MDIWindow)ws.activeWindow();
    if ( m != null )
	m.saveAs();
}


void print()
{
    MDIWindow m = (MDIWindow)ws.activeWindow();
    if ( m != null)
	m.print( printer );
}


void closeWindow()
{
    MDIWindow m = (MDIWindow)ws.activeWindow();
    if ( m != null )
	m.close();
}

void about()
{
    QMessageBox.about( this, "Qt Application Example",
			"This example demonstrates simple use of\n "
			+ "Qt's Multiple Document Interface (MDI).");
}


void aboutQt()
{
    QMessageBox.aboutQt( this, "Qt Application Example" );
}


void windowsMenuAboutToShow()
{
    windowsMenu.clear();
    int cascadeId = windowsMenu.insertItem("&Cascade", ws, SLOT("cascade()") );
    int tileId = windowsMenu.insertItem("&Tile", ws, SLOT("tile()") );
    windows = ws.windowList();
    if ( windows.size() == 0 ) {
	windowsMenu.setItemEnabled( cascadeId, false );
	windowsMenu.setItemEnabled( tileId, false );
    }
    windowsMenu.insertSeparator();
    for ( int i = 0; i < windows.size(); ++i ) {
	int id = windowsMenu.insertItem(((QWidget) windows.get(i)).caption(),
					 this, SLOT(" windowsMenuActivated( int )") );
	windowsMenu.setItemParameter( id, i );
	windowsMenu.setItemChecked( id, ws.activeWindow() == windows.get(i) );
    }
}

void windowsMenuActivated( int id )
{
    windows = ws.windowList();
    QWidget w = (QWidget) windows.get( id );
    if ( w != null )
	w.showNormal();
    w.setFocus();
}


}

