/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.kde.qt.*;


class ListenDND  extends QObject
{

public  ListenDND( QWidget w )
    {view = w;}

    void dropped( QDropEvent mime ) {
        qDebug( "Dropped Mimesource {0} into the view {1}", new Object[] { mime, view } );
        qDebug( "  Formats:" );
        int i = 0;
        String str = mime.format( i );
        qDebug( "    " + str );
        while ( str != null ) {
            qDebug( "    " + str );
            str = mime.format( ++i );
        }
    };
    void moved() {
        qDebug( "All selected items were moved to another widget" );
    }

protected QWidget view;


public static void main( String[] args )
{
    QApplication a = new QApplication( args );

    QIconView qiconview = new QIconView();
    qiconview.setSelectionMode( QIconView.Extended );

    for ( int i = 0; i < 3000; i++ ) {
	QIconViewItem item = new QIconViewItem( qiconview, "Item " + (i + 1) );
	item.setRenameEnabled( true );
    }

    qiconview.setCaption( "Qt Example - Iconview" );

    ListenDND listen_dnd = new ListenDND( qiconview );
    QObject.connect( qiconview, SIGNAL(" dropped( QDropEvent , ArrayList )"),
		      listen_dnd, SLOT(" dropped( QDropEvent  )") );
    QObject.connect( qiconview, SIGNAL(" moved()"), listen_dnd, SLOT(" moved()") );

    a.setMainWidget( qiconview );
    qiconview.show();
    qiconview.resize( qiconview.sizeHint() );

    a.exec();
    return;
}

static {
	qtjava.initialize();
}

}

