/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;

//
// The CursorView contains many labels with different cursors.
//

class CursorView extends QWidget		// cursor view
{

// cb_bits and cm_bits were generated by X bitmap program.

static final int cb_width  = 32;
static final int cb_height = 32;

static char cb_bits[] = {		// cursor bitmap
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x0f, 0x00,
   0x00, 0x06, 0x30, 0x00, 0x80, 0x01, 0xc0, 0x00, 0x40, 0x00, 0x00, 0x01,
   0x20, 0x00, 0x00, 0x02, 0x10, 0x00, 0x00, 0x04, 0x08, 0x3e, 0x3e, 0x08,
   0x08, 0x03, 0xe0, 0x08, 0xc4, 0x00, 0x00, 0x11, 0x04, 0x1e, 0x78, 0x10,
   0x02, 0x0c, 0x30, 0x20, 0x02, 0x40, 0x00, 0x20, 0x02, 0x40, 0x00, 0x20,
   0x02, 0x40, 0x00, 0x20, 0x02, 0x20, 0x04, 0x20, 0x02, 0x20, 0x04, 0x20,
   0x02, 0x10, 0x08, 0x20, 0x02, 0x08, 0x08, 0x20, 0x02, 0xf0, 0x07, 0x20,
   0x04, 0x00, 0x00, 0x10, 0x04, 0x00, 0x00, 0x10, 0x08, 0x00, 0xc0, 0x08,
   0x08, 0x3c, 0x30, 0x08, 0x10, 0xe6, 0x19, 0x04, 0x20, 0x00, 0x0f, 0x02,
   0x40, 0x00, 0x00, 0x01, 0x80, 0x01, 0xc0, 0x00, 0x00, 0x06, 0x30, 0x00,
   0x00, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00};

static final int cm_width  = 32;
static final int cm_height = 32;

static char cm_bits[] = {		// cursor bitmap mask
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xfe, 0x3f, 0x00,
   0x80, 0x07, 0xf0, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0x60, 0x00, 0x00, 0x03,
   0x30, 0x00, 0x00, 0x06, 0x18, 0x00, 0x00, 0x0c, 0x0c, 0x3e, 0x3e, 0x18,
   0x0e, 0x03, 0xe0, 0x18, 0xc6, 0x00, 0x00, 0x31, 0x07, 0x1e, 0x78, 0x30,
   0x03, 0x0c, 0x30, 0x60, 0x03, 0x40, 0x00, 0x60, 0x03, 0x40, 0x00, 0x60,
   0x03, 0x40, 0x00, 0x60, 0x03, 0x20, 0x04, 0x60, 0x03, 0x20, 0x04, 0x60,
   0x03, 0x10, 0x08, 0x60, 0x03, 0x08, 0x08, 0x60, 0x03, 0xf0, 0x07, 0x60,
   0x06, 0x00, 0x00, 0x30, 0x06, 0x00, 0x00, 0x30, 0x0c, 0x00, 0xc0, 0x18,
   0x0c, 0x3c, 0x30, 0x18, 0x18, 0xe6, 0x19, 0x0c, 0x30, 0x00, 0x0f, 0x06,
   0x60, 0x00, 0x00, 0x03, 0xc0, 0x01, 0xc0, 0x01, 0x80, 0x07, 0xf0, 0x00,
   0x00, 0xfe, 0x3f, 0x00, 0x00, 0xf8, 0x0f, 0x00};


    static int[] shapeList = {
	ArrowCursor,
	UpArrowCursor,
	CrossCursor,
	WaitCursor,
	IbeamCursor,
	SizeVerCursor,
	SizeHorCursor,
	SizeBDiagCursor,
	SizeFDiagCursor,
	SizeAllCursor,
	BlankCursor,
	SplitVCursor,
	SplitHCursor,
	PointingHandCursor,
	ForbiddenCursor,
	WhatsThisCursor
    };
    
	static String[] nameList = {
	"arrowCursor" ,
	"upArrowCursor" ,
	"crossCursor" ,
	"waitCursor" ,
	"ibeamCursor" ,
	"sizeVerCursor" ,
	"sizeHorCursor" ,
	"sizeBDiagCursor" ,
	"sizeFDiagCursor" ,
	"sizeAllCursor" ,
	"blankCursor" ,
	"splitVCursor" ,
	"splitHCursor" ,
	"pointingHandCursor" ,
	"forbiddenCursor" ,
	"whatsThisCursor"
    };

//
// Constructs a cursor view.
//

public CursorView()			// construct view
{
    setCaption( "CursorView" );			// set window caption

    QGridLayout grid = new QGridLayout( this, 5, 4, 20 );
    QLabel label;

    int i=0;
    for ( int y=0; y<4; y++ ) {			// create the small labels
	for ( int x=0; x<4; x++ ) {
	    label = new QLabel( this );
	    label.setCursor( new QCursor( shapeList[i] ) );
	    label.setText( nameList[i] );
	    label.setAlignment( AlignCenter );
	    label.setFrameStyle( QFrame.Box | QFrame.Raised );
	    grid.addWidget( label, x, y );
	    i++;
	}
    }

    QBitmap cb = new QBitmap( cb_width, cb_height, cb_bits, true );
    QBitmap cm = new QBitmap( cm_width, cm_height, cm_bits, true );
    QCursor custom = new QCursor( cb, cm );			// create bitmap cursor

    label = new QLabel( this );			// create the big label
    label.setCursor( custom );
    label.setText( "Custom bitmap cursor" );
    label.setAlignment( AlignCenter );
    label.setFrameStyle( QFrame.Box | QFrame.Sunken );
    grid.addMultiCellWidget( label, 4, 4, 0, 3 );

}


//
// Create and display a CursorView.
//

public static void main( String[] args )
{
    QApplication a = new QApplication( args );		// application object
    CursorView   v = new  CursorView();				// cursor view
    a.setMainWidget( v );
    v.setCaption("Qt Example - Cursors");
    v.show();
    a.exec();
    return;
}

static {
	qtjava.initialize();
}

}
