/*
 *  Copyright (C) 2003, Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef KJSEMBED_SQL_IMP_H
#define KJSEMBED_SQL_IMP_H

#include "bindingobject.h"
#include <tqsqlquery.h>
#include <tqsqldatabase.h>

namespace KJSEmbed {
namespace Bindings {

/**
 * TQObject Binding for QSQLQuery.
 *
 * @author Ian Reinhart Geiser, geiseri@kde.org
 * @version $Id$
 */
class SqlQuery : public BindingObject
{
	Q_OBJECT
	Q_PROPERTY( int  size READ size)
	Q_PROPERTY( int  at READ at)
	Q_PROPERTY( int  numRowsAffected READ numRowsAffected )
	Q_PROPERTY( bool  select READ isSelect)
	Q_PROPERTY( bool  valid READ isValid)
	Q_PROPERTY( bool  active READ isActive)
	Q_PROPERTY( TQString lastError READ lastError)
	Q_PROPERTY( TQString lastQuery READ lastQuery)

public:
	SqlQuery( TQObject *parent=0, const char *name=0 );
	SqlQuery( TQObject *parent, const char *name, const TQSqlQuery &q );
	//SqlQuery( const SqlQuery &copy);
	virtual ~SqlQuery();

	TQSqlQuery query(){ return m_query; }
	void setQuery(const TQSqlQuery &q) {m_query = TQSqlQuery(q); }

	int size () const;
	bool isSelect () const;
	bool isValid () const;
	bool isActive () const;
	int at () const;
	int numRowsAffected () const;
	TQString lastError () const;
	TQString lastQuery () const;

public slots:



	bool isNull ( int field );
	bool exec ( const TQString & m_query );
	TQVariant value ( int i );
	bool seek ( int i, bool relative = FALSE );
	bool next ();
	bool prev ();
	bool first ();
	bool last ();

private:
	TQSqlQuery m_query;
};

/**
 * TQObject Binding for QSQLDatabase.
 *
 * @author Ian Reinhart Geiser, geiseri@kde.org
 * @version $Id$
 */
class SqlDatabase : public BindingObject
{
    Q_OBJECT
    Q_PROPERTY( TQString  databaseName READ databaseName WRITE setDatabaseName)
    Q_PROPERTY( TQString  userName READ userName WRITE setUserName)
    Q_PROPERTY( TQString  password READ password WRITE setPassword)
    Q_PROPERTY( TQString  hostName READ hostName WRITE setHostName)
    Q_PROPERTY( int port READ port WRITE setPort)
    Q_PROPERTY( TQString  driverName READ driverName)
    Q_PROPERTY( TQString  lastError READ lastError)

public:
	SqlDatabase( TQObject *parent=0, const char *name=0 );
	virtual ~SqlDatabase();


public slots:
	void setDatabaseName (const TQString &name );
	void setUserName (const TQString &name );
	void setPassword (const TQString &password );
	void setHostName (const TQString &host );
	void setPort ( int p );
	TQString databaseName () const;
	TQString userName () const;
	TQString password () const;
	TQString hostName () const;
	int port () const;
	TQString driverName () const;
	
	bool addDatabase ( const TQString & type, const TQString & connectionName = TQSqlDatabase::defaultConnection );
	TQStringList drivers ();
	bool open ();
	bool open ( const TQString &user, const TQString &password );
	void close ();
	bool isOpen ();
	bool isOpenError ();
	TQStringList tables ();
	SqlQuery *exec( const TQString &query );
	TQString  lastError () const;
	bool transaction ();
	bool commit ();
	bool rollback ();

private:
	TQString connectionName;
	//TQSqlDatabase *db;
};


} // namespace KJSEmbed::Bindings
} // namespace KJSEmbed

#endif // KJSEMBED_SQL_IMP_H
