/***************************************************************************
 *   Copyright (C) 2003 by Julian Rockey                                   *
 *   linux@jrockey.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __marshaller_h__
#define __marshaller_h__

#include <tqmap.h>
#include <Python.h>
#include <tqstring.h>

class TQDataStream;

namespace PythonDCOP {
//   class Marshaller;
  class PCOPType;

  class Marshaller {
  public:
    Marshaller();
    ~Marshaller();
    bool marshal(const PCOPType &type, PyObject *obj, TQDataStream &str) const
      { return marsh_private(type,obj,&str); }
    bool canMarshal(const PCOPType &type, PyObject *obj) const
      { return marsh_private(type,obj,NULL); }
    bool marshalList(const PCOPType &list_type, PyObject *obj, TQDataStream *str) const;
    PyObject *demarshal(const PCOPType &type, TQDataStream &str) const
      { return demarsh_private(type, &str); }
    PyObject *demarshalList(const PCOPType &list_type, TQDataStream *str) const;
    bool marshalDict(const PCOPType &key_type, const PCOPType &value_type,
                     PyObject *obj, TQDataStream *str) const;
    PyObject *demarshalDict(const PCOPType &key_type,
                            const PCOPType &value_type,
                            TQDataStream *str) const;
    static Marshaller *instance() { return m_instance; }
  protected:
    TQMap<TQString,bool(*)(PyObject*,TQDataStream*)> m_marsh_funcs;
    TQMap<TQString,PyObject*(*)(TQDataStream*)> m_demarsh_funcs;

    static Marshaller *m_instance;

    void initFuncs();
  private:
    bool marsh_private(const PCOPType &type,
                       PyObject *obj,
                       TQDataStream *str) const;
    PyObject *demarsh_private(const PCOPType &type,
                              TQDataStream *str) const;



  };

//   bool marshall_bool(PyObject *obj, TQDataStream *str);
//   bool marshall_int(PyObject *obj, TQDataStream *str);
//   bool marshall_uint(PyObject *obj, TQDataStream *str);
//   bool marshall_double(PyObject *obj, TQDataStream *str);
//   bool marshall_QByteArray(PyObject *obj, TQDataStream *str);
//   bool marshall_QString(PyObject *obj, TQDataStream *str);
//   bool marshall_QCString(PyObject *obj, TQDataStream *str);


}

#endif
