/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __MINIPAGERBUTTON_H
#define __MINIPAGERBUTTON_H

#include <tqbutton.h>

#include "taskmanager.h"
#include "kickertip.h"

class KPixmap;
class KWinModule;
class KMiniPager;
class KSharedPixmap;
class TQLineEdit;

class KMiniPagerButton : public TQButton, public KickerTip::Client
{
    Q_OBJECT
public:
    KMiniPagerButton(int desk, bool useViewports, const TQPoint& viewport,
            KMiniPager *parent=0, const char *name=0);
    ~KMiniPagerButton();

    int desktop() { return m_desktop; }

    TQString desktopName() { return m_desktopName; }
    void setDesktopName( TQString name ) { m_desktopName = name; }

    void rename();
    void backgroundChanged();
    void windowsChanged();

    bool shouldPaintWindow( KWin::WindowInfo *info ) const;

signals:
    void buttonSelected( int desk );
    void showMenu( const TQPoint&, int );

protected:
    void drawButton(TQPainter *);
    void enterEvent(TQEvent*);
    void leaveEvent(TQEvent*);
    void resizeEvent(TQResizeEvent *ev);
    void mousePressEvent(TQMouseEvent *);
    void mouseReleaseEvent(TQMouseEvent *);
    void mouseMoveEvent(TQMouseEvent *);
    void dragEnterEvent(TQDragEnterEvent* e);
    void dragLeaveEvent(TQDragLeaveEvent* e);
    void enabledChange( bool oldEnabled );
    void dropEvent(TQDropEvent* e);

    bool eventFilter(TQObject*, TQEvent*);
    void updateKickerTip(KickerTip::Data &data);

private slots:
    void slotToggled(bool);
    void slotClicked();
    void slotDragSwitch();

    void backgroundLoaded( bool loaded );

private:
    void loadBgPixmap();
    TQRect mapGeometryToViewport(const KWin::WindowInfo&) const;
    TQPoint mapPointToViewport(const TQPoint&) const;

    KMiniPager* m_pager;
    int m_desktop;
    bool m_useViewports;
    TQString m_desktopName;
    TQPoint m_viewport;

    TQTimer m_updateCompressor;
    TQTimer m_dragSwitchTimer;
    Task::Ptr m_dragging;

    TQLineEdit* m_lineEdit;

    KSharedPixmap *m_sharedPixmap;
    KPixmap *m_bgPixmap;
    static KSharedPixmap *s_commonSharedPixmap;
    static KPixmap *s_commonBgPixmap;
    bool m_isCommon;

    Task::Ptr m_currentWindow;
    bool m_inside;
};

#endif
