/**
 *  Copyright 2003 Braden MacDonald <bradenm_k@shaw.ca>                   
 *  Copyright 2003 Ravikiran Rajagopal <ravi@ee.eng.ohio-state.edu>       
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *
 *
 *  Please see the README
 *
 */

/**
 * @file UserInfo's Dialog for changing your face.
 * @author Braden MacDonald
 */

#include <tqstring.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpixmap.h>
#include <tqimage.h>
#include <tqpushbutton.h>
#include <tqdir.h>
#include <tqcheckbox.h>

#include <kdialogbase.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kiconview.h>
#include <kimagefilepreview.h>
#include <kimageio.h>
#include <kmessagebox.h>
#include <konq_operations.h>
#include <kurl.h>

#include "chfacedlg.h"
#include "settings.h" // KConfigXT



/**
 * TODO: It would be nice if the widget were in a .ui
 */
ChFaceDlg::ChFaceDlg(const TQString& picsdir, TQWidget *parent, const char *name, bool modal)
  : KDialogBase( parent, name, modal, i18n("Change your Face"), Ok|Cancel, Ok, true )
{
  TQWidget *page = new TQWidget(this);
  setMainWidget( page );

  TQVBoxLayout *top = new TQVBoxLayout(page, 0, spacingHint());

  TQLabel *header = new TQLabel( i18n("Select a new face:"), page );
  top->addWidget( header );

  m_FacesWidget = new KIconView( page );
  m_FacesWidget->setSelectionMode( TQIconView::Single );
  m_FacesWidget->setItemsMovable( false );
  m_FacesWidget->setMinimumSize( 400, 200 );

  connect( m_FacesWidget, TQT_SIGNAL( selectionChanged( TQIconViewItem * ) ), TQT_SLOT( slotFaceWidgetSelectionChanged( TQIconViewItem * ) ) );

  connect( m_FacesWidget, TQT_SIGNAL( doubleClicked( TQIconViewItem *, const TQPoint & ) ), TQT_SLOT( slotOk() ) );

  top->addWidget( m_FacesWidget );

  // Buttons to get more pics
  TQHBoxLayout * morePics = new TQHBoxLayout( 0, 0, spacingHint() );
  TQPushButton *browseBtn = new TQPushButton( i18n("Custom &Image..."), page );
  connect( browseBtn, TQT_SIGNAL( clicked() ), TQT_SLOT( slotGetCustomImage() ) );
  morePics->addWidget( browseBtn );
#if 0
  TQPushButton *acquireBtn = new TQPushButton( i18n("&Acquire Image..."), page );
  acquireBtn->setEnabled( false );
  morePics->addWidget( acquireBtn );
#endif
  morePics->addStretch();
  top->addLayout( morePics );

  // Filling the icon view
  TQDir facesDir( picsdir );
  if ( facesDir.exists() )
  {
    TQStringList picslist = facesDir.entryList( TQDir::Files );
    for ( TQStringList::Iterator it = picslist.begin(); it != picslist.end(); ++it )
      new TQIconViewItem( m_FacesWidget, (*it).section(".",0,0), TQPixmap( picsdir + *it ) );
  }
  facesDir.setPath( KCFGUserAccount::userFaceDir() );
  if ( facesDir.exists() )
  {
    TQStringList picslist = facesDir.entryList( TQDir::Files );
    for ( TQStringList::Iterator it = picslist.begin(); it != picslist.end(); ++it )
      new TQIconViewItem( m_FacesWidget, "/"+(*it) == KCFGUserAccount::customFaceFile() ? 
		      i18n("(Custom)") : (*it).section(".",0,0),
                      TQPixmap( KCFGUserAccount::userFaceDir() + *it ) );
  }

  m_FacesWidget->setResizeMode( TQIconView::Adjust );
  //m_FacesWidget->setGridX( FACE_PIX_SIZE - 10 );
  m_FacesWidget->arrangeItemsInGrid();

  enableButtonOK( false );
  //connect( this, TQT_SIGNAL( okClicked() ), TQT_SLOT( slotSaveCustomImage() ) );

  resize( 420, 400 );
}

void ChFaceDlg::addCustomPixmap( TQString imPath, bool saveCopy )
{
  TQImage pix( imPath );
  // TODO: save pix to TMPDIR/userinfo-tmp,
  // then scale and copy *that* to ~/.faces

  if (pix.isNull())
  {
    KMessageBox::sorry( this, i18n("There was an error loading the image.") );
    return;
  }
  if ( (pix.width() > KCFGUserAccount::faceSize())
	|| (pix.height() > KCFGUserAccount::faceSize()) )
    pix = pix.scale( KCFGUserAccount::faceSize(), KCFGUserAccount::faceSize(), TQ_ScaleMin );// Should be no bigger than certain size.

  if ( saveCopy )
  {
    // If we should save a copy:
    TQDir userfaces( KCFGUserAccount::userFaceDir() );
    if ( !userfaces.exists( ) )
      userfaces.mkdir( userfaces.absPath() );

    pix.save( userfaces.absPath() + "/.userinfo-tmp" , "PNG" );
    KonqOperations::copy( this, KonqOperations::COPY, KURL::List( KURL( userfaces.absPath() + "/.userinfo-tmp" ) ), KURL( userfaces.absPath() + "/" + TQFileInfo(imPath).fileName().section(".",0,0) ) );
#if 0
  if ( !pix.save( userfaces.absPath() + "/" + imPath , "PNG" ) )
    KMessageBox::sorry(this, i18n("There was an error saving the image:\n%1").arg( userfaces.absPath() ) );
#endif
  }

  TQIconViewItem* newface = new TQIconViewItem( m_FacesWidget, TQFileInfo(imPath).fileName().section(".",0,0) , pix );
  newface->setKey( KCFGUserAccount::customKey() );// Add custom items to end
  m_FacesWidget->ensureItemVisible( newface );
  m_FacesWidget->setCurrentItem( newface );
}

void ChFaceDlg::slotGetCustomImage(  )
{
  TQCheckBox* checkWidget = new TQCheckBox( i18n("&Save copy in custom faces folder for future use"), 0 );

  KFileDialog *dlg = new KFileDialog( TQDir::homeDirPath(), KImageIO::pattern( KImageIO::Reading ),
                  this, 0, true, checkWidget);

  dlg->setOperationMode( KFileDialog::Opening );
  dlg->setCaption( i18n("Choose Image") );
  dlg->setMode( KFile::File | KFile::LocalOnly );

  KImageFilePreview *ip = new KImageFilePreview( dlg );
  dlg->setPreviewWidget( ip );
  if (dlg->exec() == TQDialog::Accepted)
      addCustomPixmap( dlg->selectedFile(), checkWidget->isChecked() );
  // Because we give it a parent we have to close it ourselves.
  dlg->close(true);
}

#if 0
void ChFaceDlg::slotSaveCustomImage()
{
  if ( m_FacesWidget->currentItem()->key() ==  USER_CUSTOM_KEY)
  {
    TQDir userfaces( TQDir::homeDirPath() + USER_FACES_DIR );
    if ( !userfaces.exists( ) )
      userfaces.mkdir( userfaces.absPath() );

    if ( !m_FacesWidget->currentItem()->pixmap()->save( userfaces.absPath() + USER_CUSTOM_FILE , "PNG" ) )
      KMessageBox::sorry(this, i18n("There was an error saving the image:\n%1").arg( userfaces.absPath() ) );
  }
}
#endif

#include "chfacedlg.moc"
