// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef _VerifyDlg_h_
#define _VerifyDlg_h_

#include <tqdialog.h>
#include <tqptrlist.h>

#include "Range.h"

class TQLabel;
class TQPushButton;

class KProcess;

class LoggerWidget;
class TapeDrive;

/**
 * @short Status dialog for verifying/restoring parts of an archive.
 */
class VerifyDlg : public TQDialog {
    Q_OBJECT
  TQ_OBJECT
    bool                _restore;
    KProcess*           _proc;
    TQString             _workingDir;
    int                 _fileno;
    const RangeList&    _ranges;
    TQString             _leftover;
    TQLabel*             _elapsedTime;
    TQLabel*             _timeRemaining;
    TQLabel*             _kbytesRead;
    TQLabel*             _transferRate;
    TQLabel*             _files;
    LoggerWidget*       _log;
    TQPushButton*        _ok;
    TQPushButton*        _save;
    TQPushButton*        _abort;
    int                 _startTime;
    float               _totalKBytes;
    int                 _fileCount;
    int                 _archiveSize;
    bool                _wroteStdin;
    bool                _aborted;
    bool                _done;
    TQString             _lastFileName;

    void updateStats();
private slots:
    void slotProcessExited( KProcess* proc );
    void slotStdout( KProcess* proc, char* buf, int len );
    void slotWroteStdin( KProcess* proc );
    void slotOK();
    void slotAbort();
protected:
    void show();
    void timerEvent( TQTimerEvent* e );
public:
    /**
     * Create a new verify/restore dialog.
     *
     * @param workingDir The directory to restore files to or verify files against.
     * @param fileno     The tape file number of the archive to verify/restore.
     * @param ranges     A list of tar block ranges to read.
     * @param restore    TRUE means restore, FALSE means verify.
     * @param parent     The parent widget for the dialog.
     * @param name       The name of this widget.
     */
    VerifyDlg( const TQString & workingDir, int fileno, const RangeList& ranges,
               bool restore = FALSE, TQWidget* parent = 0, const char* name = 0 );

    /**
     * Destroy the verify/restore dialog.
     */
    ~VerifyDlg();
};

#endif
