// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include <stdlib.h>

#include <tqcombobox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

#include <kapplication.h>
#include <kglobal.h>
#include <klocale.h>

#include "Options.h"
#include "FormatOptDlg.h"

#include "FormatOptDlg.moc"

FormatOptDlg::FormatOptDlg( const TQString & def, TQWidget* parent, const char* name )
        : TQDialog( parent, name, TRUE )
{
    setIconText( i18n( "KDat: Format Options" ) );
    setCaption( i18n( "KDat: Format Options" ) );

    TQLabel* lbl1 = new TQLabel( i18n( "Tape name:" ), this );
    TQLabel* lbl2 = new TQLabel( i18n( "Tape size:" ), this );

    int max = lbl1->sizeHint().width();
    if ( lbl2->sizeHint().width() > max ) max = lbl2->sizeHint().width();

    lbl1->setFixedSize( max, lbl1->sizeHint().height() );
    lbl2->setFixedSize( max, lbl2->sizeHint().height() );

    _entry = new TQLineEdit( this );
    _entry->setText( def );
    _entry->setFixedHeight( _entry->sizeHint().height() );

    _tapeSize = new TQLineEdit( this );
    _tapeSize->setFixedSize( 48, _tapeSize->sizeHint().height() );

    _tapeSizeUnits = new TQComboBox( this );
    _tapeSizeUnits->setFixedSize( 48, _tapeSizeUnits->sizeHint().height() );
    _tapeSizeUnits->insertItem( "MB" );
    _tapeSizeUnits->insertItem( "GB" );

    KPushButton* ok     = new KPushButton( KStdGuiItem::ok(), this );
    ok->setFixedSize( 80, ok->sizeHint().height() );
    KPushButton* cancel = new KPushButton( KStdGuiItem::cancel(), this );
    cancel->setFixedSize( 80, cancel->sizeHint().height() );

    TQVBoxLayout* l1 = new TQVBoxLayout( this, 8, 4 );
    TQHBoxLayout* l2 = new TQHBoxLayout();
    TQHBoxLayout* l3 = new TQHBoxLayout();
    TQHBoxLayout* l4 = new TQHBoxLayout();

    l1->addLayout( l2, 0 );
    l1->addLayout( l3, 0 );
    l1->addStretch( 1 );

    l1->addLayout( l4, 0 );

    l2->addWidget( lbl1, 0 );
    l2->addWidget( _entry, 1 );

    l3->addWidget( lbl2 );
    l3->addWidget( _tapeSize );
    l3->addWidget( _tapeSizeUnits );
    l3->addStretch( 1 );

    l4->addStretch( 1 );
    l4->addWidget( ok, 0 );
    l4->addWidget( cancel, 0 );

    resize( 400, 120 );

    _entry->setFocus();
    _entry->selectAll();

    connect( _entry, TQT_SIGNAL( returnPressed() ), this, TQT_SLOT( okClicked() ) );
    connect( ok    , TQT_SIGNAL( clicked() )      , this, TQT_SLOT( okClicked() ) );
    connect( cancel, TQT_SIGNAL( clicked() )      , this, TQT_SLOT( reject() ) );

    int size = Options::instance()->getDefaultTapeSize();
    if ( ( size >= 1024*1024 ) && ( size % ( 1024*1024 ) == 0 ) ) {
        // GB
        size /= 1024*1024;
        _tapeSizeUnits->setCurrentItem( 1 );
    } else {
        // MB
        size /= 1024;
        _tapeSizeUnits->setCurrentItem( 0 );
    }
    _tapeSize->setText( KGlobal::locale()->formatNumber(size, 0) );
}

FormatOptDlg::~FormatOptDlg()
{
}

void FormatOptDlg::okClicked()
{
    _name = _entry->text();

    _size = (int)KGlobal::locale()->readNumber( _tapeSize->text() );
    if ( _tapeSizeUnits->currentItem() == 0 ) {
        // MB
        _size *= 1024;
    } else {
        // GB
        _size *= 1024*1024;
    }
    
    accept();
}

TQString FormatOptDlg::getName()
{
    return _name;
}

int FormatOptDlg::getSize()
{
    return _size;
}
