// Copyright (c) 2003,2004 Charles Samuels <charles@kde.org>
// See the file COPYING for redistribution terms.

#ifndef VIEW_H
#define VIEW_H

#include <kmainwindow.h>
#include <kaction.h>
#include <klineedit.h>

#include "tree.h"

class SchemaListAction;
class TabWidget;

class View : public KMainWindow
{
Q_OBJECT
  TQ_OBJECT
	Oblique *mOblique;
	Tree *mTree;
	TQValueList<Tree*> mTrees;
	TabWidget *mTabs;
	KAction *mRemoveTabAction;
	SchemaListAction *mSchemaListAction;

public:
	View(Oblique *oblique);
	~View();

	Tree *tree() { return mTree; }

	Oblique *oblique() { return mOblique; }

public slots:
	void addFiles();
	void addDirectory();
	void addTab();
	void removeTab();

signals:
	void listHidden();
	void listShown();

private slots:
	void configureToolBars();
	void newToolBarConfig();
	void jumpTextChanged(const TQString &text);
	void use(Slice*);
	void currentTabChanged(TQWidget *);
	void setSchema(const TQString &file);

protected:
	virtual void showEvent(TQShowEvent *) { emit listShown(); }
	virtual void hideEvent(TQHideEvent *) { emit listHidden(); }
	void closeEvent(TQCloseEvent*);
};


class LineEditAction : public KWidgetAction
{
Q_OBJECT
  TQ_OBJECT
public:
	LineEditAction(const TQString &text, const TQObject *reciever, const char *slot, KActionCollection *parent, const char *name);

	KLineEdit *widget() { return static_cast<KLineEdit*>(KWidgetAction::widget()); }
	KLineEdit *lineEdit() { return widget(); }
};


#endif

