// Author: Eray Ozkural (exa) <erayo@cs.bilkent.edu.tr>, (c) 2002
//
// Copyright: GNU LGPL: http://www.gnu.org/licenses/lgpl.html

#ifndef KBUFFER_H
#define KBUFFER_H

#include <tqiodevice.h>
#include <vector>
#include <queue>

/**A buffer device for flexible and efficient buffers.

  *@author Eray Ozkural (exa)
  */

class KBuffer : public TQIODevice  {
public:
  KBuffer();
  ~KBuffer();
  /** open a memory buffer */
  bool open(int mode);
  /** read in a block of memory */
  TQ_LONG readBlock(char* data, long unsigned int maxLen);
  /** query buffer size */
#ifdef USE_QT4
  qint64 size() const;
#else // USE_QT4
  TQ_ULONG size() const;
#endif // USE_QT4
  /** No descriptions */
  void flush();
  /** Close buffer */
  void close();
  /** write a block of memory */
  TQ_LONG writeBlock(const char *data, long unsigned int maxLen);
  /** read a byte */
  int getch();
  /** undo last getch()
 */
  int ungetch(int);
  /** write a byte */
  int putch(int);
  void* data() {
    return &buf[0];
  }

#ifdef USE_QT4
	virtual inline qint64 readData ( char * data, qint64 maxSize ) { return readBlock(data, maxSize); }
	virtual inline qint64 writeData ( const char * data, qint64 maxSize ) { return writeBlock(data, maxSize); }
#endif // USE_QT4

private:
  std::vector<char> buf;
  std::vector<char>::iterator bufPos;
};

#endif
