#ifndef GUI_H
#define GUI_H

#include <kmainwindow.h>
#include <klistview.h>
#include <tqsplitter.h>
#include <tqdict.h>
#include <dcopobject.h>
#include <kurl.h>

class Renderer;

class Control : public KMainWindow
{
Q_OBJECT
  TQ_OBJECT
	
public:
	Control();

	void addCreator(const TQString &title);

public slots:
	void save(const KURL &file);
	void save();
	void saveAs();
	
	void open();
	void open(const KURL &file);
	
protected slots:
	void dropEvent(TQDropEvent *e, TQListViewItem *parent, TQListViewItem *pafter);
	void currentChanged(TQListViewItem *item);

private:
	TQWidget *mRight;
	KListView *mTree, *mCreatorsList;
	TQWidget *mConfigurator;
	
	KURL mCurrentURL;
};

class RendererListView : public KListView
{
Q_OBJECT
  TQ_OBJECT
public:
	RendererListView(TQWidget *p);
	
protected:
	virtual bool acceptDrag(TQDropEvent *event) const;
	virtual TQDragObject *dragObject() const;
};


#endif
