#ifndef GROUP_H
#define GROUP_H

#include <tqcolor.h>
#include <tqptrlist.h>

#include <kdialogbase.h>

#include <atlantic/estategroup.h>

class KColorButton;
class KLineEdit;
class KListBox;
class KPushButton;

class TQComboBox;
class TQListBoxItem;
class TQSpinBox;
class TQVGroupBox;

class ConfigEstateGroup
{
	public:
	ConfigEstateGroup() { init(); }
	ConfigEstateGroup(const TQString &name) { setName(name); init(); }
	void init() { setHousePrice(0); setGlobalPrice(0); }

	void setHousePrice(int newPrice) { m_housePrice = newPrice; }
	int housePrice()const { return m_housePrice; }
	void setGlobalPrice(int newGlobalPrice) { m_globalPrice = newGlobalPrice; }
	int globalPrice()const { return m_globalPrice; }
	const TQString &rentMath() { return m_rentMath; }
	void setRentMath(const TQString &newMath) { m_rentMath = newMath; }
	bool dynamicRent()const { return !m_rentMath.isEmpty(); }
	void setName(const TQString &name) { m_name = name; }
	const TQString &name() { return m_name; }

	const TQColor &fgColor() { return m_fgColor; }
	void setFgColor(const TQColor &color) { m_fgColor = color; }
	const TQColor &bgColor() { return m_bgColor; }
	void setBgColor(const TQColor &color) { m_bgColor = color; }

	private:
	TQColor m_fgColor;
	TQColor m_bgColor;
	TQString m_rentMath;
	int m_housePrice;
	int m_globalPrice;
	TQString m_name;
};
typedef TQValueList<ConfigEstateGroup> ConfigEstateGroupList;

class GroupEditor : public KDialogBase
{
	Q_OBJECT
  TQ_OBJECT

	public:
	GroupEditor(ConfigEstateGroupList *, TQWidget *parent=0);

	signals:
	void changed();
	void update();

	protected slots:
	virtual void slotOk();
	virtual void slotApply();

	private slots:
	void updateSettings(TQListBoxItem *item);
	void fgChanged(const TQColor &);
	void bgChanged(const TQColor &);
	void housePriceChanged(int);
	void globalPriceChanged(int);
	void rentMathChanged(const TQString &);
	void add();
	void remove();
	void selectionChanged();

	private:
	KListBox *groups;
	KLineEdit *rentMathEdit;
	KColorButton *fgButton;
	KColorButton *bgButton;
	TQWidget *pricesWidget;
	TQWidget *mathWidget;
	TQSpinBox *housePrice;
	TQSpinBox *globalPrice;
	TQVGroupBox *colorGroupBox;
	TQVGroupBox *pricesGroupBox;
	TQVGroupBox *dynamicGroupBox;
	KPushButton *removeB;

	ConfigEstateGroupList *list;
	ConfigEstateGroupList mylist;

	ConfigEstateGroup *currentGroup();
};

#endif
