/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef KTQTEMPFILE_H
#define KTQTEMPFILE_H

#include <tqvaluevector.h>
#include <tqfile.h>

/*
 * This class generates temp file names in race condition-safe way,
 * returns TQFile and filename pairs, keeps the track of opened temp files,
 * and deletes them when program exist.
 */

class KTQTempFileKeeper
{
	public:
		KTQTempFileKeeper();
		~KTQTempFileKeeper();
		
		//! Generates a temporary file name, and creates it on disk at the same time.
		//! Returns the file. If tempdir is not empty, it is used as temp directory.
		bool	generateTempFile( TQFile& file, const TQString& tempdir = TQString() );
		
		//! Closes and removes all the files from disk
		void	destroyTempFiles();
		
	private:
		TQValueVector<TQString>	m_tempFiles;
		TQString					m_tempDir;
		unsigned int			m_fileNumber;
};

#endif /* KTQTEMPFILE_H */
