/***************************************************************************
 *   Copyright (C) 2004-2005 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef KCHMDCOPIFACE_H
#define KCHMDCOPIFACE_H

#include <tqobject.h>
#include <dcopobject.h>
#include <tqstring.h>
#include <tqstringlist.h>

class KCHMDCOPIface : public TQObject, public DCOPObject
{
	Q_OBJECT
//	TQ_OBJECT
	K_DCOP
			
	public:
    	KCHMDCOPIface( TQObject *parent = 0, const char *name = 0 );
		~KCHMDCOPIface();
		
	k_dcop:
		//! Loads a CHM file \a filename , and opens the URL \a url. Use URL "/" to open default homepage
		void		loadHelpFile( const TQString& filename, const TQString& url );
	
		//! Opens a specific \a url inside the loaded CHM file
		void		openPage( const TQString& url );
		
		//! Tries to find word in index, opening the index window and scrolling it there
		void		guiFindInIndex( const TQString& word );
		
		//! Executes a search in GUI. \a query contains the complete search query.
		void		guiSearchQuery( const TQString& query );
		
		//! Executes a search; GUI is not involved and user sees nothing.
		//! \a query contains the complete search query.
		//! Returns a list of URLs, or empty array if nothing os
		TQStringList	searchQuery( const TQString& query );
};

#endif
