/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_SPINX_TOP_H
#define KBFX_SPINX_TOP_H

#include <tqimage.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqwidget.h>

#include <kiconloader.h>
#include <klineedit.h>
#include <kuser.h>

#include <kbfxconfig.h>
#include <kbfxplasmapixmapprovider.h>

class KbfxSpinxTop:public TQWidget
{
		Q_OBJECT
  TQ_OBJECT

	public:
		KbfxSpinxTop ( TQWidget * parent = 0,const char * name = 0 );
		virtual	~KbfxSpinxTop();

		virtual void paintEvent ( TQPaintEvent * );
		virtual void mousePressEvent ( TQMouseEvent * e ) ;

	public slots:

	signals:
		void textChanged ( TQString );
		void sizeChange ( int );

	private:
		void loadFaceIcon();
		void createDudeBox();
		TQString getUserName();

		TQPixmap  m_background;
		TQPixmap * m_pixmapbuff;
		TQPixmap  m_faceIcon;
		TQPixmap  m_dudeBox;
		TQString m_currentTextBuffer;
		TQString m_userName;
		TQPixmap m_iconPixmap;
		TQTimer * m_fadeTimer;


};

#endif
