/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxplasmacanvasitemwrapper.h"
#include <tqptrlist.h>
#include <kbfxplasmapixmapprovider.h>

KbfxPlasmaCanvasItemWrapper::KbfxPlasmaCanvasItemWrapper ( TQCanvas * canvas )
{
	m_canvas = canvas;
}

KbfxPlasmaCanvasItemWrapper::~KbfxPlasmaCanvasItemWrapper ()
{}

TQCanvasItem *
KbfxPlasmaCanvasItemWrapper::item ( KbfxPlasmaCanvasItem::Type __type )
{
	TQPixmap _img_sep = ( *KbfxPlasmaPixmapProvider::pixmap ( "separator" ) );
	TQImage _tmp_img = _img_sep.convertToImage();
	_tmp_img = _tmp_img.smoothScale ( ConfigInit().m_itemView_w, _img_sep.height (),TQ_ScaleFree );
	_img_sep = TQPixmap ( _tmp_img );

	TQPixmap _img_tnorm = ( *KbfxPlasmaPixmapProvider::pixmap ( "tilenormal" ) );
	_tmp_img = _img_tnorm.convertToImage();
	_tmp_img = _tmp_img.smoothScale ( ConfigInit().m_itemView_w, _img_tnorm.height (),TQ_ScaleFree );
	_img_tnorm = TQPixmap ( _tmp_img );

	TQPixmap _img_thov = ( *KbfxPlasmaPixmapProvider::pixmap ( "tilehover" ) );
	_tmp_img = _img_thov.convertToImage();
	_tmp_img = _tmp_img.smoothScale ( ConfigInit().m_itemView_w, _img_thov.height (),TQ_ScaleFree );
	_img_thov = TQPixmap ( _tmp_img );

	if ( __type == KbfxPlasmaCanvasItem::SEPARATOR )
	{
		TQValueList<TQPixmap> list;
		list.append ( _img_sep );
		KbfxPlasmaCanvasItem *_ret =
		    new KbfxPlasmaCanvasItem ( new TQCanvasPixmapArray ( list ),m_canvas );
		_ret->setType ( __type );
		return ( TQCanvasItem * ) _ret;
	}

	if ( __type == KbfxPlasmaCanvasItem::EXECUTABLE )
	{

		TQValueList<TQPixmap> list;
		list.append ( _img_tnorm );
		list.append ( _img_thov );

		TQCanvasPixmapArray * _pArray = new TQCanvasPixmapArray ( list );

		KbfxPlasmaCanvasItem *_ret = new KbfxPlasmaCanvasItem ( _pArray,
		                             m_canvas );

		_ret->setType ( __type );
		return ( TQCanvasItem * ) _ret;
	}


	return 0;
}


TQCanvasItem *
KbfxPlasmaCanvasItemWrapper::itemIndex ( KbfxPlasmaCanvasItem::Type __type )
{
	TQPixmap _img_isep = ( *KbfxPlasmaPixmapProvider::pixmap ( "indexseparator" ) );
	TQImage _tmp_img = _img_isep.convertToImage();
	_tmp_img = _tmp_img.smoothScale ( ConfigInit().m_listBox_w, _img_isep.height (),TQ_ScaleFree );
	_img_isep = TQPixmap ( _tmp_img );

	TQPixmap _img_r = ( *KbfxPlasmaPixmapProvider::pixmap ( "rhstile" ) );
	_tmp_img = _img_r.convertToImage();
	_tmp_img = _tmp_img.smoothScale ( ConfigInit().m_listBox_w, _img_r.height (),TQ_ScaleFree );
	_img_r = TQPixmap ( _tmp_img );

	TQPixmap _img_rhov = ( *KbfxPlasmaPixmapProvider::pixmap ( "rhshovertile" ) );
	_tmp_img = _img_rhov.convertToImage();
	_tmp_img = _tmp_img.smoothScale ( ConfigInit().m_listBox_w, _img_rhov.height (),TQ_ScaleFree );
	_img_rhov = TQPixmap ( _tmp_img );

	if ( __type == KbfxPlasmaCanvasItem::SEPARATOR )
	{
		TQValueList<TQPixmap> list;
		list.append ( _img_isep );
		KbfxPlasmaIndexItem *_ret =
		    new KbfxPlasmaIndexItem ( new TQCanvasPixmapArray ( list ),m_canvas );
		_ret->setType ( __type );
		return ( TQCanvasItem * ) _ret;
	}
	if ( __type  == KbfxPlasmaCanvasItem::INDEX )
	{
		TQValueList<TQPixmap> list2;
		list2.append ( _img_r );
		list2.append ( _img_rhov );
		KbfxPlasmaIndexItem *_ret = new KbfxPlasmaIndexItem ( new TQCanvasPixmapArray ( list2 ),
		                            m_canvas );

		_ret->setType ( __type );
		return ( TQCanvasItem * ) _ret;

	}
	return 0;
}

#include "kbfxplasmacanvasitemwrapper.moc"
