/***************************************************************************
                         rectitem.cpp  -  description
                             -------------------
    begin                : Do Sep 2 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
                                                                          
    This program is free software; you can redistribute it and/or modify  
    it under the terms of the GNU General Public License as published by  
    the Free Software Foundation; either version 2 of the License, or     
    (at your option) any later version.                                   
                                                                          
 ***************************************************************************/

#include "rectitem.h"

#include <tqdom.h>
#include <tqpainter.h>

RectItem::RectItem()
    : DocumentItem()
{
    init();
}

void RectItem::loadXML (TQDomElement* element)
{
    DocumentItem::loadXML( element );
    
    m_color = readXMLColor( element, "fill-color", TQt::white );
    m_filled = element->attribute( "filled", "0" ).toInt();
    m_circle = element->attribute( "circle", "0" ).toInt();
}

void RectItem::saveXML (TQDomElement* element)
{
    DocumentItem::saveXML( element );
    
    writeXMLColor( element, "fill-color", m_color );
    element->setAttribute( "filled", m_filled );
    element->setAttribute( "circle", m_circle );
}

void RectItem::draw (TQPainter* painter)
{
    if( m_circle )
    {
        if( m_filled )
        {
            painter->save();
            painter->setPen( TQPen( TQt::NoPen ) );
            painter->setBrush( m_color );
            painter->drawEllipse( rect() );
            painter->restore();
        }
    
        if( border() )
        {
            painter->save();
            painter->setPen( pen() );
            painter->drawEllipse( rect() );
            painter->restore();
        }
    }
    else
    {
        if( m_filled )
            painter->fillRect( rect(), m_color );
        
        DocumentItem::drawBorder( painter );
    }
}

void RectItem::drawZpl( TQTextStream* stream )
{
    // TODO: refactor later and respect millimeters
    int thick = pen().width();
    
    *stream << ZPLUtils::fieldOrigin( rect().x(), rect().y() );
    if( m_circle )
        *stream << TQString("~GE%1,%2,%3,B").arg( rect().width() ).arg( rect().height() ).arg( thick );
    else
        *stream << TQString("~GB%1,%2,%3,B,0").arg( rect().width() ).arg( rect().height() ).arg( thick );
}

void RectItem::drawIpl( TQTextStream* stream, IPLUtils* utils )
{
    // TODO: refactor later and respect millimeters
    int thick = pen().width();
    
    if( m_circle )
        qDebug("Cirlce not implemented for IPL");    
    else
    {
        int counter = utils->counter();
        
        TQString s = TQString("W%1;").arg( counter ); // field number
    
        s += utils->fieldOrigin( rect().x(), rect().y() );
        s += TQString("l%1;").arg( rect().width() ); // box length
        s += TQString("h%1;").arg( rect().height() ); // box height
        s += TQString("w%1;").arg( thick );
    
        *stream << utils->field( s );
    }
}

void RectItem::drawEPcl( TQTextStream* stream )
{
    TQString s = TQString("C %1").arg( rect().x()+1 );
    s += TQString(" %1").arg( rect().y()+1 );
    s += TQString(" %1").arg( rect().width() );
    s += TQString(" %1").arg( rect().height() );
    s += TQString(" %1 2").arg( pen().width() );

    *stream << EPCLUtils::field( s );
}

void RectItem::init()
{
    m_color = TQt::white;
    m_filled = true;
    m_circle = false;
    setRect( TQRect( 0, 0, 20, 20 ) );
}

void RectItem::setColor (const TQColor & c) 
{
    m_color = c;    
}

TQColor RectItem::color ()  const 
{
    return m_color;    
}

void RectItem::setFilled (bool f) 
{
    m_filled = f;    
}

bool RectItem::filled ()  const 
{
    return m_filled;    
}

void RectItem::setCircle (bool b) 
{
    m_circle = b;    
}

bool RectItem::circle ()  const 
{
    return m_circle;    
}

