/***************************************************************************
                          batchprinter.h  -  description
                             -------------------
    begin                : Sat Jan 10 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BATCHPRINTER_H
#define BATCHPRINTER_H

#include "measurements.h"

#include <tqmap.h>
#include <tqvaluelist.h>

namespace KABC {
    class AddresseeList;
}

class Definition;
class Label;
class KPrinter;
class Measurements;
class TQBuffer;
class TQPainter;
class TQProgressDialog;
class TQWidget;
class TQPaintDevice;

typedef TQValueList< TQMap<TQString,TQString> > TVariableList;
/**
    This class is responsible for batch printing of articles.
    It is also responsible for creating images of all articles.
    @author Dominik Seichter
*/
class BatchPrinter
{
    public:
        typedef enum EOutputFormat { POSTSCRIPT = 0, IMAGE, BCP };
        enum EImageFileName { E_ARTICLE, E_BARCODE, E_CUSTOM };

        struct data {
            int number;
            TQString article_no;
            TQString group;
        };

        /** Use this constructor if you want to print to
          * a printer.
          */
        BatchPrinter( KPrinter* p, TQWidget* _parent );
        /** This constructor is used in image gernaration mode.
          * @p path is the path to an existing directory where
          * the images are saved.
          */
        BatchPrinter( const TQString & path, TQWidget* p );
        
        /** Use this constructor to print to a barcode printer @p path
          * with format @p format
          */
        BatchPrinter( const TQString & path, int format, TQWidget* _parent );
        
        ~BatchPrinter();

        inline void setBuffer( TQBuffer* b ) { buffer = b; }
        void setCustomer( const TQString & s ) { m_customer = s; }

        /** Specify the label on which is printed first on the page.
         *  The first label on the page (top/left) has the index 1, 
         *  the second label is index 2 ...
         */
        inline void setMove( int m ) { 
            m_move = m > 0 ? --m : 0;
        }

        /** set the sql data for the batchprinter
         *  @p list will be deleted by the batchprinter
         */
        void setData( TQValueList<data>* list );

        /** set the variable data for the batchprinter
         *  @p list will be deleted by the batchprinter
         */
        void setData( TVariableList* list );

        /** set the address data for the batchprinter
         *  @p list will be deleted by the batchprinter
         */
        void setData( KABC::AddresseeList* list );

	inline void setImageFilename( const EImageFileName e ) { m_image_filename = e; }
	inline void setImageCustomFilename( const TQString & name ) { m_image_custom_filename = name; };
	inline void setImageFormat( const TQString & f ) { m_image_format = f; }
        inline void setSerial( const TQString & s, unsigned int inc ) { m_serial = s; m_increment = inc; }
        inline void setName( const TQString & s ) { m_name = s; }
        inline void setDefinition( Definition* d ) { def = d; }
        inline void setLabels( int l ) { m_labels = l; }
        inline void setEvents( bool b ) { m_events = b; }

        /** start the batch printing on a printer
          */
        void start();
        /** start image generation
          */
        void startImages();
        /** start printing to a barcode printer
          */
        void startBCP();
    private:
	/** create a label which gets intialized either with m_vardata or m_data
	 *  @p number is set to the number of times this label should be printed.
	 */
	Label* initLabel( int* number = NULL );

        /** starts a new page on the printer, if the
          * current label does not fit anymore on the current pageh
          */
        void checkForNewPage( Label* label );
        /** draw a border around the current label using TQPainter @p painter
          */
        void drawBorders();
        /** start a "new line" on the printer,
          * i.e. beginn the second row of labels
          * on the page.
          */
        void changeLine();
        void proccessEvents( int lb, TQString value = TQString(), Label* label = 0 );
        void printXLabel( int lb, Label* label, const TQString & value );
        void moveLabels();

	/** print the labels using data from the m_data structure
	  */
	void startPrintData( TQProgressDialog* progress );
	/** print the labels using data from the m_vardata or m_addrdata structure
	  */
	void startPrintVarData( TQProgressDialog* progress );

        /** Create and return a progressdialog
          */
        TQProgressDialog* createProgressDialog( const TQString & caption );
        bool checkProgressDialog( TQProgressDialog* progress );

        Definition* def;
        Measurements m_measure;
        TQValueList<data>* m_data;
	TVariableList* m_vardata;
        KABC::AddresseeList* m_addrdata;

        TQString m_serial;
        TQString m_name;
        TQString m_customer;
        /** Path for image output
          * or device for bcp output
          */
        TQString m_path;
        /** defines the image format to be used
          */
	TQString m_image_format;

        unsigned int m_cur_data_count;

        /** format for bcp output
          */
        int m_bcp_format;

        /** defines the format of the filename for images
         */
	EImageFileName m_image_filename;

	/** prefix for custom filenames if m_image_filename = E_CUSTOM
	 */
	TQString m_image_custom_filename;

        /** enable/disable events
          */
        bool m_events;

        unsigned int m_increment;
        unsigned int m_move;
        /** number of labels to print for the progress dialog
          */
        unsigned int m_labels;

        /** height of the current page in pixel.
          */
        double pageh;
        double curw;
        double curh;
        int c_h;
        int c_w;

	TQPaintDevice* m_paintDevice;

        TQBuffer* buffer;
        KPrinter* printer;
        TQPainter* painter;
        /** parent for dialogs
          */
        TQWidget* parent;
};

#endif
