/*
 * krecord.h
 *
 * Copyright (C) 2004-2005 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef KRECORD_H
#define KRECORD_H

#include <tqdialog.h>
#include <tqpixmap.h>

#include <kpushbutton.h>
#include <klistview.h>

#include "channeldesc.h"
#include "ktimereditor.h"



class KRecord : public TQDialog
{
	Q_OBJECT
  TQ_OBJECT

public:

	KRecord( TQStringList chanList, TQPtrList<RecTimer> *t, TQWidget *parent, TQSize size );
	~KRecord();

	TQStringList channelsList;

protected slots:

	virtual void accept();
	void newTimer();
	void editTimer();
	void deleteTimer();
	void refresh();

private:

	TQListViewItem* where( RecTimer *rt, bool add=false );

	KPushButton *newBtn, *editBtn, *deleteBtn, *okBtn;
	KListView *list;
	TQPtrList<RecTimer> *timers;
	TQPixmap isRecording, yesRepeat;

signals:

	void updateTimer(RecTimer*, int);

};

#endif /* KRECORD_H */
