//
// C++ Implementation: k9settings
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "k9settings.h"

#include <tqframe.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <tqlayout.h>

k9settings::k9settings(TQWidget *parent,const TQString &caption):  KDialogBase (IconList,caption,
        Ok|Apply|Cancel, Ok) {

    setInitialSize(TQSize(750,350), false);

    TQFrame *frDevices;
    frDevices=addPage (i18n("Devices"),i18n("Devices not detected by k9copy"),KGlobal::iconLoader()->loadIcon("blockdevice", KIcon::Panel, KIcon::SizeMedium));
    TQGridLayout *grid = new TQGridLayout(frDevices, 0, 0, 10 );
    m_configDlg=new kConfigDlg(frDevices);
    grid->addWidget(m_configDlg,0,0);


    TQFrame *frDVD;
    frDVD=addPage (i18n("DVD"),i18n("DVD Backup"),KGlobal::iconLoader()->loadIcon("dvdcopy", KIcon::Panel, KIcon::SizeMedium));
    grid = new TQGridLayout(frDVD, 0, 0, 10 );
    m_prefDVD =new k9prefDVD(frDVD);
    grid->addWidget(m_prefDVD,0,0);

    //TODO afficher uniquement si mencoder et mplayer installés

    TQFrame *frMencoder;
    frMencoder=addPage (i18n("MEncoder"),i18n("MPEG-4 Codecs"),KGlobal::iconLoader()->loadIcon("mencoder", KIcon::Panel, KIcon::SizeMedium));
    m_prefMencoder =new k9prefMencoder(frMencoder);



    TQFrame *frMPEG4;
    frMPEG4=addPage (i18n("MPEG-4"),i18n("MPEG-4 Encoding"),KGlobal::iconLoader()->loadIcon("mp4", KIcon::Panel, KIcon::SizeMedium));
    grid = new TQGridLayout(frMPEG4, 0, 0, 10 );
    m_prefMPEG4 =new k9prefMPEG4(frMPEG4);
    grid->addWidget(m_prefMPEG4,0,0);

    grid = new TQGridLayout(frMencoder, 0, 0, 10 );
    grid->addWidget(m_prefMencoder,0,0);

    TQFrame *frPreview;
    frPreview=addPage (i18n("Preview"),i18n("Title preview"),KGlobal::iconLoader()->loadIcon("mplayer", KIcon::Panel, KIcon::SizeMedium));
    grid = new TQGridLayout(frPreview, 0, 0, 10 );
    m_prefPreview =new k9prefPreview(frPreview);
    grid->addWidget(m_prefPreview,0,0);

    TQFrame *frAuthor;
    frAuthor=addPage(i18n("Authoring"),i18n("Authoring"),KGlobal::iconLoader()->loadIcon("author",KIcon::Panel,KIcon::SizeMedium));
    grid = new TQGridLayout(frAuthor, 0, 0, 10 );
    m_prefAuthor =new k9prefAuthor(frAuthor);
    grid->addWidget(m_prefAuthor,0,0);


    connect(this, TQT_SIGNAL(okClicked()), TQT_SLOT(slotOkClicked()));
    connect(this, TQT_SIGNAL(applyClicked()), TQT_SLOT(slotApplyClicked()));
}

void k9settings::slotOkClicked() {
    m_configDlg->save();
    m_prefDVD->save();
    m_prefMPEG4->save();
    m_prefMencoder->save();
    m_prefPreview->save();
    m_prefAuthor->save();
}

void k9settings::slotApplyClicked() {
   slotOkClicked();
  
   m_prefMPEG4->load();
}

k9settings::~k9settings() {
 /*   delete m_configDlg;
    delete m_prefDVD;
    delete m_prefMPEG4;
    delete m_prefMencoder;
    delete m_prefPreview;
*/
}

#include "k9settings.moc"
