//
// C++ Interface:
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef K9MAIN_H
#define K9MAIN_H
#include "k9common.h"
#include "k9cddrive.h"
#include "images.h"
#include "k9mainw.h"
#include "kconfigdlg.h"
#include "k9playbackoptions.h"
#include <tqstring.h>
#include <kmessagebox.h>
#include <tqlistview.h>
#include <kmainwindow.h>
#include <kaboutdata.h>
#include <tqevent.h>
#include <kfiledialog.h>
#include <tqlistbox.h>
#include "k9copy.h"
#include <tqmutex.h>

enum  eStreamType {SUB,AUD,VID,NONE,CHAP} ;
enum  eObjectType {TITLE,CHAPTER,TITLESET,STREAM,ROOT};

class LvItem : public TQListViewItem {
public:
    LvItem( TQListViewItem *parent,eObjectType _objectType)
            : TQListViewItem( parent), obj( NULL ) {
        objectType=_objectType;
    }
    LvItem( TQListView *parent,eObjectType _objectType)
            : TQListViewItem( parent), obj( NULL ) {
        objectType=_objectType;
    }
    eObjectType objectType;
    TQObject *obj;
    virtual int rtti () const;
    int compare ( TQListViewItem * i, int col, bool ascending ) const;
    void paintCell ( TQPainter * p, const TQColorGroup & cg, int column, int width, int align );
};

class k9Main;
class k9DVD;
class  k9DVDAudioStream;
class  k9DVDSubtitle;
class k9DVDTitle;
class KLibFactory;
class k9PlaybackOptions;
class k9LangSelect;
class k9UpdateFactor;

class ckLvItem : public TQCheckListItem {
public:
    ckLvItem( TQListViewItem *parent,k9Main *dlg,eObjectType _objectType)
            : TQCheckListItem( parent,"",TQCheckListItem::CheckBox) {
        mainDlg=dlg;
        obj=NULL;
        stream=NULL;
        streamType=NONE;
        language="";
        objectType=_objectType;
    }
    ckLvItem( TQListView *parent,k9Main *dlg,eObjectType _objectType)
            : TQCheckListItem( parent,"",TQCheckListItem::CheckBox) {
        mainDlg=dlg;
        obj=NULL;
        stream=NULL;
        streamType=NONE;
        language="";
        objectType=_objectType;
    }
    eStreamType streamType;
    eObjectType objectType;

    k9Main *mainDlg;
    k9DVDTitle *mainTitle;
    TQObject *obj;
    TQObject *stream;
    TQString language;
    virtual int rtti () const;
    void paintCell ( TQPainter * p, const TQColorGroup & cg, int column, int width, int align );
    int compare ( TQListViewItem * i, int col, bool ascending ) const;
    double getstreamSize();

protected:
    void stateChange(bool state);

};


class k9DVDListItem : public TQObject {
    Q_OBJECT
  TQ_OBJECT
public:
    k9DVDAudioStream *audioStream;
    k9DVDSubtitle *subtitle;
    k9DVDTitle *title;
    ckLvItem *listItem;
    eStreamType streamType;
public:
    k9DVDListItem(TQObject *DVD,ckLvItem *List,eStreamType type);
};


class k9Main : public MainDlg {
    Q_OBJECT
  TQ_OBJECT

public:

    k9Main(TQWidget* parent = 0, const char* name = 0,  k9CdDrives *_drives=0 );
    ~k9Main();
    /*$PUBLIC_FUNCTIONS$*/
    void addTitle(k9DVDTitle *track);
    void addChapters(TQListViewItem *_parent,k9DVDTitle *_title);
    void updateSelection();
    void checkAll(bool state);
    void checkTS( bool _state,ckLvItem *_item );
    void checkTitle(bool state, ckLvItem *_item);
    void checkLang(TQString lang, eStreamType streamType,bool state);
    bool getupdating();
    void saveSettings();
    void setDVDSize();
    static int compare(double v1,double v2);
    void readSettings();
    bool getquickScan() {
        return m_quickScan;
    };
    void setPlaybackOptions(k9PlaybackOptions *_value) {
        m_playbackOptions=_value;
    };
    void setLangSelect(k9LangSelect *_value) {
        m_langSelect=_value;
    };
    TQObjectList *getItems() {
        return &items;
    };
    void updateFactor();
    bool withMenus();
    k9DVD *dvd;
    void eject();
private slots:
    virtual void          listView1CurrentChanged( TQListViewItem * );
    virtual void          bSaveClick();
    virtual void	  cbOutputDevActivated(int);
    virtual void	  bInputOpenClick();
    virtual void	  bInputOpenDirClick();
    virtual void	  foundMountPoint (const TQString &mountPoint, unsigned long kBSize, unsigned long kBUsed, unsigned long kBAvail);
    virtual void 	  fspDone();
    virtual void updateFactor_internal();
    virtual void	   deviceAdded(k9CdDrive *_drive);
    virtual void	   deviceRemoved(k9CdDrive *_drive);
    virtual void	   expanded(TQListViewItem*);
    virtual void	   collapsed (TQListViewItem*);
public slots:
    /*$PUBLIC_SLOTS$*/
    virtual void          PreviewTitle();
    virtual void          CreateMP4();
    virtual void	  extractMPEG2();
    virtual void          Copy();
    virtual void          Open();
    virtual void	   Clone(TQString _input,TQString _output);
    virtual void	   setInput(TQString _input);
    virtual void 	   setOutput(TQString _output);
    virtual void 	  volumeChanged(const TQString &device,const TQString &volumeName);

    void setDrives(k9CdDrives* _value);

protected:
    /*$PROTECTED_FUNCTIONS$*/
    TQObjectList items;
    k9DVDListItem *addListItem(TQObject *DVD,ckLvItem *List,eStreamType type);

    void readDrives();
    void addDrive (k9CdDrive *_drive);
    k9Copy *m_parent;
    TQPtrList<ckLvItem> tsItems;
    TQPtrList<ckLvItem> chItems;
    ckLvItem * root;
    TQPtrList <k9CdDrive> driveList;
    TQPtrList <k9CdDrive> recorderList;
    k9CdDrives *drives;
    TQPixmap pxVideo;
    TQPixmap pxSound;
    TQPixmap pxText;
    TQPixmap pxChapter;
    TQMutex m_mutex;
    bool updating;
    bool fspFinish;
    long fspAvail;
    void closeEvent( TQCloseEvent* ce );
    void closeDVD();
    KLibFactory *m_factory;
    TQString  getDevice(TQComboBox *_combo);
    k9UpdateFactor *m_update;
    //PREFERENCES
    TQString m_prefOutput;
    bool m_useDvdAuthor;
    bool m_quickScan;
    int  m_prefSize;
    bool m_prefK3b;
    bool m_prefMenu;
    bool m_prefAutoBurn;
    k9PlaybackOptions *m_playbackOptions;
    k9LangSelect *m_langSelect;

    KMdiToolViewAccessor *m_toolView;
    KDockWidget *m_dockWidget;
protected slots:
    /*$PROTECTED_SLOTS$*/
    void itemRenamed ( TQListViewItem *item, int col );
signals: // Signals
    /** No descriptions */
    void sig_progress(TQString str);
    void changeStatusbar(const TQString& str,int id);
    void changeCaption(const TQString& str);
    void showPreview(k9DVD *_dvd,k9DVDTitle * title,int chapter);
    void stopPreview();
    void SelectionChanged(k9DVD *_dvd,bool _withMenus);
    void changedTitle(k9DVDTitle *_title);
private:
    void fillLvLanguages();
    void updateLvLang(const eStreamType streamType,const TQString & lang) ;
    long getFreeSpace(const TQString & _path);
    void setProgressWindow(TQWidget *_widget);
    void removeProgressWindow();


};

#endif

