//
// C++ Interface: k9menubutton
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9MENUBUTTON_H
#define K9MENUBUTTON_H

#include <tqobject.h>
#include <tqpixmap.h>
#include <tqimage.h>
#include <tqcanvas.h>

/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/
class k9MenuButton;
class k9CanvasSprite : public TQCanvasSprite {
public:
    k9CanvasSprite (TQCanvasPixmapArray *a,TQCanvas *canvas,k9MenuButton *button);
    virtual int rtti() const {
        return 1000;
    }
    void update();

    k9MenuButton* getButton() const;

private:
    k9MenuButton *m_button;
};


class k9MenuButton : public TQObject {
    Q_OBJECT
  TQ_OBJECT
public:
    enum eTextPosition {BOTTOM=1,RIGHT=2};

    k9MenuButton(TQCanvas *parent = 0, const char *name = 0);

    ~k9MenuButton();
    void setWidth(int _value,bool _reload=true);
    int getWidth();
    void setHeight(int _value,bool _reload=true);
    int getHeight();
    void setTop(int _value,bool _reload=true);
    void setLeft(int _value,bool _reload=true);
    void setFont(TQFont _font);
    TQFont getFont();
    void setColor(TQColor _color);
    TQColor getColor();
    void setText(TQString _text);
    TQString getText();
    void select(bool);
    int getTop();
    int getLeft();

    void moveBy(int x,int y,bool _reload=true);
    void update();
public slots:
    void setImage(const TQImage &_image);
    void setImage(const TQString &_fileName);

    void setTextPosition(const eTextPosition& _value);
    eTextPosition getTextPosition() const;

    TQImage getImage() const;

    void setScript(const TQString& _value);
    TQString getScript() const;

    void setAngle(int _value);
    int getAngle() const;

	k9CanvasSprite* getSprite() const;

	void setNum(int _value);
	

	int getNum() const;
	
	

private:
    TQCanvas *m_canvas;
    TQCanvasPixmapArray m_pixmapArray;
    TQCanvasPixmap *m_pixmap;
    k9CanvasSprite *m_sprite;
    int m_num;
    TQCanvasText *m_text;
    TQImage m_image;
    int  m_width;
    int m_height;
    int m_angle;
    eTextPosition m_textPosition;
    TQString m_script;
    void loadImage();
signals:
    void sigsetTop(int);
    void sigsetLeft(int);
    void sigsetWidth(int);
    void sigsetHeight(int);

    void sigsetFont(const TQFont &);
    void sigsetColor(const TQColor &);
    void sigsetImage(k9MenuButton *,const TQImage &);
    void sigsetText(const TQString &);
    void sigsetTextPosition(int);
};

#endif
