/* 
 *
 * $Id: k3bisooptions.h 619556 2007-01-03 17:38:12Z trueg $
 * Copyright (C) 2003 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2007 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#ifndef K3B_ISO_OPTIONS_H
#define K3B_ISO_OPTIONS_H

#include <tqstring.h>
#include "k3b_export.h"

class KConfigBase;


class LIBK3B_EXPORT K3bIsoOptions
{
 public:
  K3bIsoOptions();

  bool forceInputCharset() const { return m_bForceInputCharset; }
  const TQString& inputCharset() const { return m_inputCharset; }

  void setForceInputCharset( bool b ) { m_bForceInputCharset = b; }
  void setInputCharset( const TQString& cs ) { m_inputCharset = cs; }

	
  // -- mkisofs-options ----------------------------------------------------------------------
  bool createRockRidge() const { return m_createRockRidge; }
  bool createJoliet() const { return m_createJoliet; }
  bool createUdf() const { return m_createUdf; }
  bool ISOallowLowercase() const { return m_ISOallowLowercase || ISOuntranslatedFilenames(); }
  bool ISOallowPeriodAtBegin() const { return m_ISOallowPeriodAtBegin || ISOuntranslatedFilenames(); }
  bool ISOallow31charFilenames() const { return m_ISOallow31charFilenames || ISOmaxFilenameLength() || ISOuntranslatedFilenames(); }
  bool ISOomitVersionNumbers() const { return m_ISOomitVersionNumbers || ISOmaxFilenameLength(); }
  bool ISOomitTrailingPeriod() const { return m_ISOomitTrailingPeriod || ISOuntranslatedFilenames(); }
  bool ISOmaxFilenameLength() const { return m_ISOmaxFilenameLength || ISOuntranslatedFilenames(); }
  bool ISOrelaxedFilenames() const { return m_ISOrelaxedFilenames || ISOuntranslatedFilenames(); }
  bool ISOnoIsoTranslate() const { return m_ISOnoIsoTranslate; }
  bool ISOallowMultiDot() const { return m_ISOallowMultiDot || ISOuntranslatedFilenames(); }
  bool ISOuntranslatedFilenames() const { return m_ISOuntranslatedFilenames; }
  bool followSymbolicLinks() const { return m_followSymbolicLinks; }
  bool createTRANS_TBL() const { return m_createTRANS_TBL; }
  bool hideTRANS_TBL() const { return m_hideTRANS_TBL; }
  bool jolietLong() const { return m_jolietLong; }

  bool preserveFilePermissions() const { return m_preserveFilePermissions; }

  int ISOLevel() const { return m_isoLevel; }
  const TQString& systemId() const { return m_systemId; }
  const TQString& applicationID() const { return m_applicationID; }
  const TQString& volumeID() const { return m_volumeID; }
  const TQString& volumeSetId() const { return m_volumeSetId; }
  int volumeSetSize() const { return m_volumeSetSize; }
  int volumeSetNumber() const { return m_volumeSetNumber; }
  const TQString& publisher() const { return m_publisher; }
  const TQString& preparer() const { return m_preparer; }
  const TQString& abstractFile() const { return m_abstractFile; }
  const TQString& copyrightFile() const { return m_copyrightFile; }
  const TQString& bibliographFile() const { return m_bibliographFile; }
	
  void setCreateRockRidge( bool b ) { m_createRockRidge = b; }
  void setCreateJoliet( bool b ) {  m_createJoliet = b; }
  void setCreateUdf( bool b ) { m_createUdf = b; }
  void setISOallowLowercase( bool b ) {  m_ISOallowLowercase = b; }
  void setISOallowPeriodAtBegin( bool b ) {  m_ISOallowPeriodAtBegin = b; }
  void setISOallow31charFilenames( bool b ) {  m_ISOallow31charFilenames = b; }
  void setISOomitVersionNumbers( bool b ) {  m_ISOomitVersionNumbers = b; }
  void setISOomitTrailingPeriod( bool b ) {  m_ISOomitTrailingPeriod = b; }
  void setISOmaxFilenameLength( bool b ) {  m_ISOmaxFilenameLength = b; }
  void setISOrelaxedFilenames( bool b ) {  m_ISOrelaxedFilenames = b; }
  void setISOnoIsoTranslate( bool b ) {  m_ISOnoIsoTranslate = b; }
  void setISOallowMultiDot( bool b ) {  m_ISOallowMultiDot = b; }
  void setISOuntranslatedFilenames( bool b ) {  m_ISOuntranslatedFilenames = b; }
  void setFollowSymbolicLinks( bool b ) {  m_followSymbolicLinks = b; }
  void setCreateTRANS_TBL( bool b ) {  m_createTRANS_TBL = b; }
  void setHideTRANS_TBL( bool b ) {  m_hideTRANS_TBL = b; }
  void setJolietLong( bool b ) { m_jolietLong = b; }
	
  void setISOLevel( int i ) { m_isoLevel = i; }
  void setSystemId( const TQString& s ) { m_systemId = s; }
  void setApplicationID( const TQString& s ) { m_applicationID = s; }

  /**
   * Set the filesystems volume id.
   *
   * max length for this field is 32 chars.
   */
  void setVolumeID( const TQString& s ) { m_volumeID = s; }
  void setVolumeSetId( const TQString& s ) { m_volumeSetId = s; }
  void setVolumeSetSize( int size ) { m_volumeSetSize = size; }
  void setVolumeSetNumber( int n ) { m_volumeSetNumber = n; }
  void setPublisher( const TQString& s ) { m_publisher = s; }
  void setPreparer( const TQString& s ) { m_preparer = s; }
  void setAbstractFile( const TQString& s ) { m_abstractFile = s; }
  void setCoprightFile( const TQString& s ) { m_copyrightFile = s; }
  void setBibliographFile( const TQString& s ) { m_bibliographFile = s; }

  void setPreserveFilePermissions( bool b ) { m_preserveFilePermissions = b; }
  // ----------------------------------------------------------------- mkisofs-options -----------

  enum whiteSpaceTreatments { noChange = 0, replace = 1, strip = 2, extended = 3 };

  void setWhiteSpaceTreatment( int i ) { m_whiteSpaceTreatment = i; }
  int whiteSpaceTreatment() const { return m_whiteSpaceTreatment; }
  const TQString& whiteSpaceTreatmentReplaceString() const { return m_whiteSpaceTreatmentReplaceString; }
  void setWhiteSpaceTreatmentReplaceString( const TQString& s ) { m_whiteSpaceTreatmentReplaceString = s; }

  bool discardSymlinks() const { return m_discardSymlinks; }
  void setDiscardSymlinks( bool b ) { m_discardSymlinks = b; }

  bool discardBrokenSymlinks() const { return m_discardBrokenSymlinks; }
  void setDiscardBrokenSymlinks( bool b ) { m_discardBrokenSymlinks = b; }

  bool doNotCacheInodes() const { return m_doNotCacheInodes; }
  void setDoNotCacheInodes( bool b ) { m_doNotCacheInodes = b; }

  void save( KConfigBase* c, bool saveVolumeDesc = true );

  static K3bIsoOptions load( KConfigBase* c, bool loadVolumeDesc = true );
  static K3bIsoOptions defaults();

 private:
  // volume descriptor
  TQString m_volumeID;
  TQString m_applicationID;
  TQString m_preparer;
  TQString m_publisher;
  TQString m_systemId;
  TQString m_volumeSetId;
  TQString m_abstractFile;
  TQString m_copyrightFile;
  TQString m_bibliographFile;

  int m_volumeSetSize;
  int m_volumeSetNumber;	

  bool m_bForceInputCharset;
  TQString m_inputCharset;

  // mkisofs options -------------------------------------
  bool m_createRockRidge;    // -r or -R
  bool m_createJoliet;             // -J
  bool m_createUdf;                // -udf
  bool m_ISOallowLowercase;   // -allow-lowercase
  bool m_ISOallowPeriodAtBegin;   // -L
  bool m_ISOallow31charFilenames;  // -I
  bool m_ISOomitVersionNumbers;   // -N
  bool m_ISOomitTrailingPeriod;   // -d
  bool m_ISOmaxFilenameLength;     // -max-iso9660-filenames (forces -N)
  bool m_ISOrelaxedFilenames;      // -relaxed-filenames
  bool m_ISOnoIsoTranslate;        // -no-iso-translate
  bool m_ISOallowMultiDot;          // -allow-multidot
  bool m_ISOuntranslatedFilenames;   // -U (forces -d, -I, -L, -N, -relaxed-filenames, -allow-lowercase, -allow-multidot, -no-iso-translate)
  bool m_followSymbolicLinks;       // -f
  bool m_createTRANS_TBL;    // -T
  bool m_hideTRANS_TBL;    // -hide-joliet-trans-tbl

  bool m_preserveFilePermissions;   // if true -R instead of -r is used
  bool m_jolietLong;

  bool m_doNotCacheInodes;
	
  int m_isoLevel;


  int m_whiteSpaceTreatment;
  TQString m_whiteSpaceTreatmentReplaceString;

  bool m_discardSymlinks;
  bool m_discardBrokenSymlinks;
};

#endif
