/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2004-10-05
 * Description : a tool bar for slideshow 
 * 
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef TOOL_BAR_H
#define TOOL_BAR_H

#include <tqwidget.h>

// Local includes.

#include "digikam_export.h"

class TQToolButton;

namespace Digikam
{

class ToolBarPriv;

class DIGIKAM_EXPORT ToolBar : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT
    
public:

    ToolBar(TQWidget* parent);
    ~ToolBar();

    bool canHide() const;
    bool isPaused() const;
    void setPaused(bool val);

    void setEnabledPlay(bool val);
    void setEnabledNext(bool val);
    void setEnabledPrev(bool val);

protected:

    void keyPressEvent(TQKeyEvent *event);
    
signals:

    void signalNext();
    void signalPrev();
    void signalClose();
    void signalPlay();
    void signalPause();

private slots:

    void slotPlayBtnToggled();
    void slotNexPrevClicked();

private:

    ToolBarPriv *d;

    friend class SlideShow;
};

}   // Namespace Digikam

#endif /* TOOL_BAR_H */
