/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-12-21
 * Description : digiKam image editor tool to correct picture 
 *               colors using an ICC color profile
 *
 * Copyright (C) 2005-2006 by F.J. Cruz <fj.cruz@supercable.es>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef IMAGEEFFECT_ICCPROOF_H
#define IMAGEEFFECT_ICCPROOF_H

// Digikam include.

#include "imagedlgbase.h"

class TQCheckBox;
class TQComboBox;
class TQVButtonGroup;
class TQButtonGroup;
class TQHButtonGroup;
class TQRadioButton;
class TQPushButton;
class TQToolBox;

class KURLRequester;
class KIntNumInput;

namespace Digikam
{
class ICCTransform;
class ImageWidget;
class HistogramWidget;
class ColorGradientWidget;
class DColor;
class ICCPreviewWidget;
class ImageCurves;
class CurvesWidget;
}

namespace DigikamImagesPluginCore
{

class ImageEffect_ICCProof : public Digikam::ImageDlgBase
{
    Q_OBJECT
  TQ_OBJECT

public:

    ImageEffect_ICCProof(TQWidget* parent);
    ~ImageEffect_ICCProof();

protected:

    void finalRendering();

private:

    void readUserSettings();
    void writeUserSettings();
    void resetValues();

    void getICCInfo(const TQString&);
    void getICCInfo(const TQByteArray&);

    bool useBPC();
    bool doProof();
    bool checkGamut();
    bool embedProfile();

    bool useEmbeddedProfile();
    bool useBuiltinProfile();
    bool useDefaultInProfile();
    bool useSelectedInProfile();

    bool useDefaultSpaceProfile();
    bool useSelectedSpaceProfile();

    bool useDefaultProofProfile();
    bool useSelectedProofProfile();

private slots:

    void slotUser2();
    void slotUser3();
    void slotEffect();
    void slotChannelChanged(int);
    void slotScaleChanged(int);
    void slotSpotColorChanged(const Digikam::DColor &);    
    void slotColorSelectedFromTarget(const Digikam::DColor &);
    void slotToggledWidgets(bool);
    void slotInICCInfo();
    void slotProofICCInfo();
    void slotSpaceICCInfo();
    void slotCMDisabledWarning();
    void processLCMSURL(const TQString&);

private:

    enum HistogramScale
    {
        Linear = 0,
        Logarithmic
    };

    enum ColorChannel
    {
        LuminosityChannel = 0,
        RedChannel,
        GreenChannel,
        BlueChannel
    };

    enum ICCSettingsTab
    {
        GENERALPAGE=0,
        INPUTPAGE,
        WORKSPACEPAGE,
        PROOFINGPAGE,
        LIGHTNESSPAGE
    };

    bool                            m_cmEnabled;
    bool                            m_hasICC;

    uchar                          *m_destinationPreviewData;

    TQComboBox                      *m_channelCB;
    TQComboBox                      *m_renderingIntentsCB;

    TQCheckBox                      *m_doSoftProofBox;
    TQCheckBox                      *m_checkGamutBox;
    TQCheckBox                      *m_embeddProfileBox;
    TQCheckBox                      *m_BPCBox;

    TQRadioButton                   *m_useEmbeddedProfile;
    TQRadioButton                   *m_useInDefaultProfile;
    TQRadioButton                   *m_useInSelectedProfile;
    TQRadioButton                   *m_useProofDefaultProfile;
    TQRadioButton                   *m_useProofSelectedProfile;
    TQRadioButton                   *m_useSpaceDefaultProfile;
    TQRadioButton                   *m_useSpaceSelectedProfile;
    TQRadioButton                   *m_useSRGBDefaultProfile;

    TQString                         m_inPath;
    TQString                         m_spacePath;
    TQString                         m_proofPath;

    TQButtonGroup                   *m_optionsBG;
    TQButtonGroup                   *m_inProfileBG;
    TQButtonGroup                   *m_spaceProfileBG;
    TQButtonGroup                   *m_proofProfileBG;

    TQHButtonGroup                  *m_scaleBG;
    TQVButtonGroup                  *m_renderingIntentBG;
    TQVButtonGroup                  *m_profilesBG;

    TQByteArray                      m_embeddedICC;

    TQToolBox                       *m_toolBoxWidgets;

    KIntNumInput                   *m_cInput;

    KURLRequester                  *m_inProfilesPath;
    KURLRequester                  *m_spaceProfilePath;
    KURLRequester                  *m_proofProfilePath;

    Digikam::DImg                  *m_originalImage;

    Digikam::CurvesWidget          *m_curvesWidget;

    Digikam::ImageCurves           *m_curves;

    Digikam::ImageWidget           *m_previewWidget;

    Digikam::ColorGradientWidget   *m_hGradient;

    Digikam::HistogramWidget       *m_histogramWidget;

    Digikam::ICCPreviewWidget      *m_iccInPreviewWidget;
    Digikam::ICCPreviewWidget      *m_iccSpacePreviewWidget;
    Digikam::ICCPreviewWidget      *m_iccProofPreviewWidget;
};

}  // NameSpace DigikamImagesPluginCore

#endif  // IMAGEEFFECT_ICCPROOF_H
