// (c) 2005 Seb Ruiz <me@sebruiz.net>
// See COPYING file for licensing information.

#ifndef AMAROK_PODCASTSETTINGS_H
#define AMAROK_PODCASTSETTINGS_H

#include "kdialogbase.h"    //baseclass

#include <kurl.h>

#include <tqptrlist.h>

class PodcastChannel;
class PodcastEpisode;
class PodcastSettingsDialogBase;
class TQDomNode;
class TQDomElement;

enum MediaFetch{ STREAM=0, AUTOMATIC=1 };

class PodcastSettings
{
    public:
        PodcastSettings( const TQDomNode &channelSettings, const TQString &title );
        PodcastSettings( const PodcastSettings *parentSettings, const TQString &title );
        PodcastSettings( const TQString &title ); // standard settings
        PodcastSettings( const TQString &title, const TQString &save, const bool autoScan,
                         const int fetchType, const bool autotransfer, const bool purge, const int purgecount );

        const TQString &saveLocation() { return m_saveLocation; }
        const TQString &title() { return m_title; }
        bool    autoscan()         { return m_autoScan; }
        int     fetchType()        { return m_fetch; }
        bool    autoTransfer()     { return m_addToMediaDevice; }
        bool    hasPurge()         { return m_purge; }
        int     purgeCount()       { return m_purgeCount; }

        TQString m_title;    //the title of the podcast or category these settings belong to
        TQString m_saveLocation;
        bool    m_autoScan;
        int     m_fetch;
        bool    m_addToMediaDevice;
        bool    m_purge;
        int     m_purgeCount;
};


class PodcastSettingsDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

    public:
        PodcastSettingsDialog( PodcastSettings *list, TQWidget* parent=0 );
        PodcastSettingsDialog( const TQPtrList<PodcastSettings> &list, const TQString &caption, TQWidget* parent=0 );

        bool    configure();
        PodcastSettings *getSettings() { return m_settings; }

    protected:
        bool    hasChanged();

    protected slots:
        void    checkModified();
        void    slotOk();
        void    slotUser1();

    private:
        void init();
        void setSettings( PodcastSettings *settings );
        TQString requesterSaveLocation();

        PodcastSettingsDialogBase *m_ps;
        TQPtrList<PodcastSettings> m_settingsList;
        PodcastSettings           *m_settings;
};

#endif /*AMAROK_PODCASTSETTINGS_H*/
