#################################################
#
#  (C) 2010-2011 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

find_program( RUBY_EXECUTABLE "ruby" )
if( NOT RUBY_EXECUTABLE )
  tde_message_fatal( "ruby is required, but was not found on your system" )
endif( )

# In ruby 1.9.x, ruby.h is located in a different location than previous releases.
execute_process(
  COMMAND ${RUBY_EXECUTABLE} -rrbconfig -e "puts Config.expand( Config::MAKEFILE_CONFIG['MAJOR'] )"
  OUTPUT_VARIABLE RUBY_VERSION_MAJOR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )
if( _result )
  tde_message_fatal( "Unable to run ${RUBY_EXECUTABLE}!\n RUBY is correctly installed?" )
endif( )
execute_process(
  COMMAND ${RUBY_EXECUTABLE} -rrbconfig -e "puts Config.expand( Config::MAKEFILE_CONFIG['MINOR'] )"
  OUTPUT_VARIABLE RUBY_VERSION_MINOR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )
if( _result )
  tde_message_fatal( "Unable to run ${RUBY_EXECUTABLE}!\n RUBY is correctly installed?" )
endif( )
set( RUBY_VERSION ${RUBY_VERSION_MAJOR}${RUBY_VERSION_MINOR} )
if ( "${RUBY_VERSION}" GREATER "18" )
  execute_process(
    COMMAND ${RUBY_EXECUTABLE} -rrbconfig -e "puts Config.expand( Config::MAKEFILE_CONFIG['rubyhdrdir'] )"
    OUTPUT_VARIABLE RUBY_INCLUDE_DIR
    RESULT_VARIABLE _result
    OUTPUT_STRIP_TRAILING_WHITESPACE )
  if( _result )
    tde_message_fatal( "Unable to run ${RUBY_EXECUTABLE}!\n RUBY is correctly installed?" )
  endif( )
else( )
  execute_process(
    COMMAND ${RUBY_EXECUTABLE} -rrbconfig -e "puts Config.expand( Config::MAKEFILE_CONFIG['archdir'] )"
    OUTPUT_VARIABLE RUBY_INCLUDE_DIR
    RESULT_VARIABLE _result
    OUTPUT_STRIP_TRAILING_WHITESPACE )
  if( _result )
    tde_message_fatal( "Unable to run ${RUBY_EXECUTABLE}!\n RUBY is correctly installed?" )
  endif( )
endif( )
execute_process(
  COMMAND ${RUBY_EXECUTABLE} -rrbconfig -e "puts Config.expand( Config::MAKEFILE_CONFIG['arch'] )"
  OUTPUT_VARIABLE RUBY_ARCH
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )
if( _result )
  tde_message_fatal( "Unable to run ${RUBY_EXECUTABLE}!\n RUBY is correctly installed?" )
endif( )
execute_process(
  COMMAND ${RUBY_EXECUTABLE} -rrbconfig -e "puts Config.expand( Config::MAKEFILE_CONFIG['LIBRUBYARG_SHARED'] )"
  OUTPUT_VARIABLE RUBY_LDFLAGS
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )
if( _result )
  tde_message_fatal( "Unable to run ${RUBY_EXECUTABLE}!\n RUBY is correctly installed?" )
endif( )

if( RUBY_INCLUDE_DIR AND RUBY_LDFLAGS )
  message( STATUS "Found RUBY: ${RUBY_EXECUTABLE}" )
  message( STATUS "  RUBY_INCLUDE_DIR: ${RUBY_INCLUDE_DIR}" )
  message( STATUS "  RUBY_LDFLAGS: ${RUBY_LDFLAGS}" )
  message( STATUS "  RUBY_VERSION_MAJOR: ${RUBY_VERSION_MAJOR}")
  message( STATUS "  RUBY_VERSION_MINOR: ${RUBY_VERSION_MINOR}")
  message( STATUS "  RUBY_ARCH: ${RUBY_ARCH}")
endif( )
if ( "${RUBY_VERSION_MAJOR}${RUBY_VERSION_MINOR}" VERSION_LESS "19" )
  message( STATUS "  You have an older version of Ruby! (<1.9)")
  set ( HAVE_OLD_RUBY 1 CACHE INTERNAL "" )
endif( )
