/*
  Copyright (c) 2006  Nikolaj Hald Nielsen <nhnFreespirit@gmail.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#include "magnatuneredownloadhandler.h"


#include "amarok.h"
#include "debug.h"


#include "tqdir.h"
#include "tqmessagebox.h"
#include <klocale.h>



MagnatuneRedownloadHandler::MagnatuneRedownloadHandler(TQWidget * parent)
{
    m_parent = parent;
    m_redownloadDialog = 0;
    m_downloadDialog = 0;
    m_albumDownloader = 0;
}


MagnatuneRedownloadHandler::~MagnatuneRedownloadHandler()
{
}

void MagnatuneRedownloadHandler::showRedownloadDialog( )
{

    TQStringList previousDownloads = GetPurchaseList();

    if (previousDownloads.isEmpty()) {

        //No previously purchased track information found. No more to do here...
        TQMessageBox::information( m_parent, i18n( "No purchases found!" ) ,
                                  i18n( "No previous purchases have been found. Nothing to redownload..." ) + "\n" );
        return;
    }

    if (m_redownloadDialog == 0) {
        m_redownloadDialog = new MagnatuneRedownloadDialog( m_parent );
        connect( m_redownloadDialog, TQT_SIGNAL( redownload( TQString) ), this, TQT_SLOT( redownload( TQString ) ) );
        connect( m_redownloadDialog, TQT_SIGNAL(cancelled() ), this, TQT_SLOT( selectionDialogCancelled() ));
    }


    m_redownloadDialog->setRedownloadItems( previousDownloads );

    m_redownloadDialog->show();

}

TQStringList MagnatuneRedownloadHandler::GetPurchaseList( )
{
    TQDir purchaseInfoDir( Amarok::saveLocation( "magnatune.com/purchases/" ) );

    purchaseInfoDir.setFilter( TQDir::Files);
    purchaseInfoDir.setSorting( TQDir::Name );

    const TQFileInfoList *list = purchaseInfoDir.entryInfoList();
    TQFileInfoListIterator it( *list );
    TQFileInfo *fi;

    TQStringList returnList;

    while ( (fi = it.current()) != 0 ) {
        returnList.append(fi->fileName());
        ++it;
    }

    return returnList;

}

void MagnatuneRedownloadHandler::redownload( TQString storedInfoFileName )
{

    TQDir purchaseInfoDir( Amarok::saveLocation( "magnatune.com/purchases/" ) );
    TQString absFileName = purchaseInfoDir.absPath() + '/' + storedInfoFileName;

   debug() << "Redownload file: " << absFileName << endl;

    if ( m_albumDownloader == 0 )
    {
        m_albumDownloader = new MagnatuneAlbumDownloader();
        connect( m_albumDownloader, TQT_SIGNAL( downloadComplete( bool ) ), this, TQT_SLOT( albumDownloadComplete( bool ) ) );
    }


    if (m_downloadDialog == 0) {
        m_downloadDialog = new MagnatuneDownloadDialog(m_parent);
         connect( m_downloadDialog, TQT_SIGNAL( downloadAlbum( MagnatuneDownloadInfo *  ) ), m_albumDownloader, TQT_SLOT( downloadAlbum( MagnatuneDownloadInfo * ) ) );
    }


    MagnatuneDownloadInfo * downloadInfo = new MagnatuneDownloadInfo();
    if ( downloadInfo->initFromFile( absFileName ) )
    {

        debug() << "Showing download dialog" << endl;
        m_downloadDialog->setDownloadInfo( downloadInfo );
        m_downloadDialog->show();
    }
    else
    {

        TQMessageBox::information( m_parent, i18n( "Could not re-download album" ),
                                  i18n( "There seems to be a problem with the selected redownload info file." ) + "\n" );

    }

}

void MagnatuneRedownloadHandler::selectionDialogCancelled( )
{
    if (m_redownloadDialog != 0) {
        m_redownloadDialog->hide();
        delete m_redownloadDialog;
        m_redownloadDialog = 0;
    }
}

void MagnatuneRedownloadHandler::albumDownloadComplete( bool success )
{
    Q_UNUSED( success );
    //cleanup time!

    if (m_downloadDialog != 0) {
       delete m_downloadDialog;
       m_downloadDialog = 0;
    }
    if (m_albumDownloader != 0) {
        delete m_albumDownloader;
        m_albumDownloader = 0;
    }

}

#include "magnatuneredownloadhandler.moc"
