/* -*- C++ -*- file adept/tagchooser.h
   written by Peter Rockai <me@mornfall.net> */

#include <kdebug.h>
#include <tqlayout.h>

#include <apt-front/utils/range.h>
#include <apt-front/cache/cache.h>
#include <apt-front/cache/entity/tag.h>

#include <adept/extendablelist.h>

#ifndef EPT_TAGCHOOSER_H
#define EPT_TAGCHOOSER_H

namespace adept {

using namespace aptFront;

class FacetItem;
class FacetExtender;
class TagChooser;

class TagItem : public KListViewItem {
public:
    typedef cache::entity::Tag Tag;
    virtual TQString text( int ) const;
    TagItem( TagChooser *t );
    TagItem( FacetItem *t );
    void setTag( Tag t ) { m_tag = t; }
    Tag tag() { return m_tag; }
protected:
    bool m_toplevel;
    Tag m_tag;
};

class FacetItem : public KListViewItem
{
public:
    typedef cache::entity::Facet Facet;
    virtual TQString text( int ) const;
    FacetItem( TagChooser *t );
    void setFacet( Facet f ) { m_facet = f; }
    void removeTag( TagItem::Tag );
protected:
    Facet m_facet;
};

class TagChooser : public KListView, public cache::Observer // ExtendableList
{ 
    Q_OBJECT
  TQ_OBJECT
public:
    typedef cache::entity::Tag Tag;
    typedef cache::entity::Facet Facet;
    TagChooser( TQWidget *p = 0, const char *n = 0 );
    virtual void notifyPreRebuild( cache::component::Base * );
public slots:
    virtual void setTags( TagChooser::Tag::Set );
    void setTitle( TQString s ) {
        setColumnText( 0, s );
    }
    void openToplevel();

protected:
    virtual void dragEnterEvent( TQDragEnterEvent *e );
    virtual void dropEvent( TQDropEvent* e );
    virtual void contentsDragEnterEvent( TQDragEnterEvent *e ) {
        kdDebug() << "TagChooser::contentsDragEnterEvent" << endl;
        dragEnterEvent( e );
    }
    virtual void contentsDropEvent( TQDropEvent *e ) {
        kdDebug() << "TagChooser::contentsDropEvent" << endl;
        dropEvent( e );
    }
    virtual TQDragObject *dragObject();
    Tag::Set m_tags;
    std::map< Facet, FacetItem * > m_facets;
};

}

#endif
