/* -*- C++ -*- adept/packagedetails.h
   written by Peter Rockai <me@mornfall.net> */

#include <apt-front/cache/entity/package.h>
#include <adept/packagedetailsui.h>
#include <adept/lister.h>

#include <tqmutex.h>
#include <tqguardedptr.h>

#ifndef EPT_PACKGEDETAILS_H
#define EPT_PACKGEDETAILS_H

class KToolBarButton;
class TQThread;

namespace adept {

using namespace aptFront;

class PackageDetails : public PackageDetailsUi, public Lister::RangeProvider,
                       public cache::Observer
{
    Q_OBJECT
  TQ_OBJECT
public:
    enum ButtonID { BForward, BBack, BShow };
    PackageDetails( TQWidget *p = 0, const char *n = 0 );
    void setPackage( cache::entity::Package );
    void setHasForward( bool );
    void setHasBack( bool );
    virtual Lister::Range listerRange();
    void notifyPostChange( cache::component::Base * );
    void notifyPreRebuild( cache::component::Base * );
    void notifyPostRebuild( cache::component::Base * );
signals:
    void showList();
    void back();
    void forward();
    void detailsRequested( Lister::Entity );
protected slots:
    void loadFileList();
    void updateLogical();
protected:
    void loadFileListWorker();
    cache::entity::StablePackage m_package;
    TQMutex m_qtMutex;
    TQThread *m_thread;
    TQGuardedPtr< EntityActor > m_logicalAct, m_removeAct;
    int m_fileListRunning;

};

}

#endif
