#include <kdebug.h>
#include <tqpopupmenu.h>
#include <tqheader.h>
#include <klineedit.h>

#include <tagcoll/InputMerger.h>

#include <apt-front/cache/component/tags.h>
#include <apt-front/cache/entity/package.h>

#include <adept/lister.h>
#include <adept/filterlist.h>
#include <adept/quickfilter.h>
#include <adept/statefilter.h>
#include <adept/easytagfilter.h>
#include <adept/tagfilter.h>


using namespace adept;
using namespace Tagcoll;

// TODO: Beat enrico till this lands in some of our libs...
template< typename PKG, typename TAG >
class TagcollConsumerAdaptor :
    public utils::ConsumerImpl< PKG,TagcollConsumerAdaptor<PKG, TAG> >
{
protected:
	Consumer<PKG, TAG>& m_out;

public:
	TagcollConsumerAdaptor( Consumer<PKG, TAG>& out) : m_out( out ) {}
	virtual void consume( const PKG& a ) {
		if (a != PKG())
			m_out.consume(a, a.tags());
	}
};

PredicateInterface::PredicateInterface( TQWidget *w, const char *n )
    : ItemExtender( w, n )
{
}

void PredicateInterface::widgetsChanged() {
    kdDebug() << "PredicateInterface::widgetsChanged()" << endl;
    emit predicateDrop( m_pred );
    m_pred = predicate();
    emit predicateAdd( m_pred );
    downcast< FilterItem >( item() ).setPredicate( m_pred );
}

FilterList::FilterList( TQWidget *parent, const char *name )
    : ExtendableList( parent, name ),
      m_pred( predicate::True< entity::Entity >() ),
      m_hidden( predicate::True< entity::Entity >() )
{
    m_itemsSeen = 0;
    // addColumn( " ", 20 );
    addColumn( i18n( "Active filters" ), 240 );
    // setSortColumn( -1 );
    /* setItemsMovable( true );
    setDragEnabled( true );
    setAcceptDrops( true ); */
    setResizeMode( LastColumn );
    setAllColumnsShowFocus (true);

    resize( 240, 180 );
    connect( this, TQT_SIGNAL(
                 contextMenuRequested( TQListViewItem *, const TQPoint
                                       &, int ) ),
             this, TQT_SLOT( contextMenu( TQListViewItem *, const
                                      TQPoint &, int) ) );
    connect( this, TQT_SIGNAL( extendersChanged() ),
             this, TQT_SLOT( updateHeight() ) );
}

void FilterList::emitPredicateChanged() {
    predicateChanged( m_hidden and m_pred );
}

void FilterList::updateHeight() {
    int h = header()->height() + 4;
    for ( TQListViewItem *i = firstChild(); i != 0; i = i->nextSibling() ) {
        h += i->totalHeight();
    }
    // int h = contentsHeight() + header()->height() + 4; // magic constant
    setMinimumHeight( h );
    setMaximumHeight( h );
}

void FilterList::drawContents( TQPainter *p, int a, int b, int c, int d ) {
    if ( m_itemsSeen != childCount() ) {
        m_itemsSeen = childCount();
        updateHeight();
    } // hmm, doesn't work... bah :p
    KListView::drawContents( p, a, b, c, d );
}

void FilterList::plugLister( Lister *l ) {
    m_lister = l;
    connect( this, TQT_SIGNAL( predicateChanged( ListerPredicate ) ),
             l, TQT_SLOT( baseSet( ListerPredicate ) ) );
}

void FilterList::setPredicate( Predicate p ) {
    clear();
    m_pred = p;
    appendPredicate( p );
    emitPredicateChanged();
}

void FilterList::setHiddenPredicate( Predicate p ) {
    m_hidden = p;
    emitPredicateChanged();
}

void FilterList::editorPredicateDrop( Predicate p ) {
    m_pred = predicate::remove( m_pred, p );
    emitPredicateChanged();
}

void FilterList::editorPredicateAdd( Predicate p ) {
    kdDebug() << "FilterList::editorPredicateAdd" << endl;
    m_pred = m_pred and p;
    emitPredicateChanged();
}

void FilterList::appendPredicate( Predicate p ) {
    if (p.is< And >()) {
        And a = p;
        for (utils::Range< Predicate > r = a.parts();
             r != r.end(); ++r )
            appendPredicate( *r );
    } else if (p.is< predicate::True< entity::Entity > >() ) {
        // we generally ignore truth
    } else {
        m_pred = m_pred and p;
        // kdDebug() << p.serialize() << endl;
        // kdDebug() << p.prettyPrint() << endl;
        FilterItem *i;
        i = new FilterItem( this );
        i->setPredicate( p );
    }
}

void FilterList::contextMenu( TQListViewItem *it, const TQPoint &pt, int /*c*/ )
{
    std::cerr << "FilterList::contextMenu(p);" <<  std::endl;
    FilterItem *i = dynamic_cast< FilterItem * >( it );
    if (! i)
        return;
    TQPopupMenu *m = new TQPopupMenu( this );
    m->insertItem( i18n( "Reset Filter" ), 1 );
    m->insertItem( i18n( "Remove Filter" ), 0 );
    m->insertSeparator();
    m->insertItem( i18n( "Add Quick Filter" ), 8 );
    m->insertItem( i18n( "Add State Filter" ), 9 );
    m->insertItem( i18n( "Add Tag Filter" ), 10 );
    m->insertItem( i18n( "Add Easy Tag Filter" ), 11 );
    // m->insertItem( "Add Tag Filter", tagMenu() );
    m_context = i;
    connect(m, TQT_SIGNAL(activated(int)), this, TQT_SLOT(contextActivated(int)));
    m->exec(pt);
    delete m;
}


void FilterList::contextActivated( int i )
{
    predicate::Predicate< entity::Entity > p;
    switch (i) {
    case 0:
        m_pred = predicate::remove( m_pred, m_context->predicate() );
        delete m_context;
        emitPredicateChanged();
        return;
    case 1:
        m_context->reset();
        return;
    case 8:
        p = predicate::adapt< entity::Entity >(
            QuickFilter< entity::Package >() );
        break;
    case 9:
        p = predicate::adapt< entity::Entity >(
            StateFilter< entity::Package >() );
        break;
    case 10:
        p = predicate::adapt< entity::Entity >(
            TagFilter< entity::Package >() );
        break;
    case 11:
        p = predicate::adapt< entity::Entity >(
            EasyTagFilter< entity::Package >() );
        break;
    }
    if (p.impl()) {
        kdDebug() << "summary: " <<
            downcast< InterfacingPredicate >( p ).summary() << endl;
        appendPredicate( p );
        emitPredicateChanged();
    }
}

ItemExtender *FilterItem::createExtender()
{
    PredicateInterface *o = 0;
    if (m_pred.is< QuickFilter< entity::Package > >()) {
        o = new QuickFilterWidget( list(), 0 );
    } else if (m_pred.is< StateFilter< entity::Package > >()) {
        o = new StateFilterWidget( list(), 0 );
    } else if (m_pred.is< EasyTagFilter< entity::Package > >()) {
        o = new EasyTagFilterWidget( list(), 0 );
    } else if (m_pred.is< TagFilter< entity::Package > >()) {
        o = new TagFilterWidget( list(), 0 );
    }
    if (o) {
        o->setPredicate( m_pred );
        TQObject::connect( o, TQT_SIGNAL( predicateAdd( Predicate ) ),
                          list(), TQT_SLOT( editorPredicateAdd( Predicate ) ) );
        TQObject::connect( o, TQT_SIGNAL( predicateDrop( Predicate ) ),
                          list(), TQT_SLOT( editorPredicateDrop( Predicate ) ) );
    }
    return o;
}

TQString FilterItem::text( int c ) const {
    InterfacingPredicate &ip = downcast< InterfacingPredicate >( m_pred.impl() );
    if (c == 0)
        return ip.summary();
    return u8( "" );
}
