#include <kprogress.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <klocale.h>
#include "acqprogresswidget.h"
#include "acqprogress.h"

using namespace adept;

AcqProgressWidget::AcqProgressWidget( TQWidget *parent, const char *name )
    : AcqProgressWidgetUi( parent, name )
{
    m_statusRef = m_status;
    m_progress->setTotalSteps( 100 );
    m_progress->setProgress( 0 );
    connect(m_status, TQT_SIGNAL( totalProgress( int ) ),
             this, TQT_SLOT( setProgress( int ) ) );
    connect(m_status, TQT_SIGNAL( statusChanged( AcqStatus::Status ) ),
            this, TQT_SLOT( statusChange( AcqStatus::Status ) ) );
    connect( m_cancel, TQT_SIGNAL( clicked() ),
             m_status, TQT_SLOT( cancel() ) );
}

void AcqProgressWidget::statusChange( AcqStatus::Status s )
{
    TQString t;
    switch (s) {
        case AcqStatus::StWaiting:
            t = i18n( "Waiting for headers (%p%)" );
            break;
        case AcqStatus::StDownloading:
            t = i18n( "Downloading (%p%)" );
            break;
        case AcqStatus::StDone:
            t = i18n( "Done (%p%)" );
            m_progress->setProgress( 100 );
            break;
    }
    m_progress->setFormat( t );
}

void AcqProgressWidget::setProgress( int p )
{
    if (p < 0) {
        m_progress->setTotalSteps( 0 );
        m_progress->setProgress( m_progress->progress() + 1 );
    } else {
        m_progress->setTotalSteps( 100 );
        m_progress->setProgress( p );
    }
}

#include "acqprogresswidget.moc"
