#ifndef ABAKUS_RESULTLISTVIEWTEXT_H
#define ABAKUS_RESULTLISTVIEWTEXT_H
/*
 * resultlistviewtext.h - part of abakus
 * Copyright (C) 2004, 2005 Michael Pyne <michael.pyne@kdemail.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "resultlistview.h"
#include "numerictypes.h"

class TQPainter;
class TQColorGroup;
class TQFontMetrics;

// This class shows the results shown in the MainWindow result pane.
class ResultListViewText : public KListViewItem
{
    public:
    ResultListViewText(KListView *listView,
                      const TQString &text,
		      const TQString &result,
		      ResultListViewText *after,
		      bool isError = false);

    ResultListViewText(KListView *listView,
                      const TQString &text,
		      const Abakus::number_t &result,
		      ResultListViewText *after,
		      bool isError = false);

    TQString expressionText() const { return m_text; }
    TQString resultText() const { return m_result; }

    bool wasError() const { return m_wasError; }
    unsigned stackPosition() const { return m_stackPosition; }

    void setStackPosition(unsigned pos);

    // Redisplays the text by calling value.toString again.
    void precisionChanged();

    // Reimplemented from KListViewItem
    virtual void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int align);
    virtual int width(const TQFontMetrics &fm, const TQListView *lv, int c) const;

    // Reimplemented to remove trailing zeroes from results.
    virtual void setText(int column, const TQString &text);

    private:
    TQString m_text, m_result;
    bool m_wasError;
    unsigned m_stackPosition;
    Abakus::number_t m_value;
};

#endif
